
import { _decorator, Component, Node, Vec2, EventTouch, RigidBody, v3, Collider, ICollisionEvent, ERigidBodyType, animation, UITransform} from 'cc';
const { ccclass, property } = _decorator;
 
@ccclass('test')
export class test extends Component {

    @property({type: Node, tooltip: '触摸节点'})
    private touch_node: Node = null;

    @property({type: Node, tooltip: '球'})
    private qiu: Node = null;

    /** 起始点 */
    private start_pos: Vec2 = null;

    /** 保存触摸点 */
    private set_touch: EventTouch = null;

    /** 点击id */
    touch_id: number = -1;

    start () {
        this.touch_node.on(Node.EventType.TOUCH_START, this.on, this);
        this.touch_node.on(Node.EventType.TOUCH_MOVE, this.move, this);
        this.touch_node.on(Node.EventType.TOUCH_END, this.up, this);
        this.touch_node.on(Node.EventType.TOUCH_CANCEL, this.up, this);

        let wuli = this.qiu.getComponent(RigidBody);
        wuli.useCCD = true;
    }

    on(touch: EventTouch, event: string){
        if(this.start_pos){
            return
        }

        this.touch_id = touch.getID();

        this.start_pos = touch.getLocation();
    }

    move(touch: EventTouch, event: string){
        if(touch.getID() != this.touch_id){
            return
        }

        // let pos = touch.getLocation();
        // let dir = pos.subtract(this.start_pos).normalize();

        // let angle = dir.signAngle(v2(1, 0));

        // //将弧度转换为欧拉角
        // let degree = angle / Math.PI * 180;

        // this.gan_parent.setRotationFromEuler(-degree, 0, 0);
    }

    up(touch: EventTouch, event: string){
        if(touch.getID() != this.touch_id){
            return
        }

        //旧版，直接对球施加力
        let pos = touch.getLocation();

        let liliang = 10000;

        let wuli = this.qiu.getComponent(RigidBody);
        wuli.applyForce(v3(0, 0, -liliang));

        //初始化
        this.touch_id = -1;
        this.start_pos = null;
    }

    update (deltaTime: number) {
    }
}
