
import { _decorator, Component, Node, EventTouch, view, input, Input } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('canvasts')
export class canvasts extends Component {
    @property(Node)
    camera: Node = null;

    onLoad() {
        input.on(Input.EventType.TOUCH_MOVE, this.onTouchMove, this);
    }

    start() {

    }

    // update (deltaTime: number) {

    // }

    // 移动视角
    onTouchMove(event: EventTouch) {
        let offset = event.getDelta();
        this.camera.setPosition(this.camera.position.x - offset.x / view.getScaleX(), this.camera.position.y - offset.y / view.getScaleX(), this.camera.position.z);
    }
}
