import { assetManager, Component, instantiate, Layers, Prefab, _decorator } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    start() {
        assetManager.loadBundle('BundleA', (error, bundle) => {
            bundle.load('PrefabA', Prefab, (error, prefab) => {
                const node = instantiate(prefab);
                node.layer = Layers.Enum.UI_2D;
                node.setPosition(-40, 0, 0);
                node.parent = this.node
            })
        })
        assetManager.loadBundle('BundleB', (error, bundle) => {
            bundle.load('PrefabB', Prefab, (error, prefab) => {
                const node = instantiate(prefab);
                node.layer = Layers.Enum.UI_2D;
                node.setPosition(40, 0, 0);
                node.parent = this.node
            })
        })
    }

    release() {
        const node = this.node.getChildByName('PrefabB')
        node.destroy();
        node.parent = null;

        const bundle = assetManager.getBundle('BundleA');
        {
            // 这会爆炸
            bundle.releaseAll();
            assetManager.removeBundle(bundle);
        }
        {
            // 这不会爆炸，说明releaseAll不管引用计数
            // bundle.releaseUnusedAssets();
        }
    }
}

