import { _decorator, Component, director, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Ant')
export class Ant extends Component
{
    out:Vec3 = new Vec3();
    moveSpeed:number = 3;
    isMoving:boolean = false;
    start()
    {
        director.getScene().on('MOVE_PLAYER',this.onMoveHandler,this);
    }

    onMoveHandler(isMoving:boolean,angle:number)
    {
        this.isMoving = isMoving;
        if (angle)
        {
            this.node.setRotationFromEuler(0,-(angle),0);
        }
    }

    update(dt:number)
    {
        this.updateMove(dt)
    }

    moveInterval:number = 0;
    updateMove(dt:number)
    {
        if (this.isMoving)
        {
            this.out.x = 0;
            this.out.z = -this.moveSpeed * 0.016;
            this.out.y = 0;
            this.node.translate(this.out,0);
        }
    }
}
