import { _decorator, Component, Node, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CameraFollow')
export class CameraFollow extends Component
{
    @property(Node)
    target:Node=null;

    pos:Vec3;
    rot:Vec3;
    
    out:Vec3=new Vec3();

    onLoad()
    {
        cc.debug.setDisplayStats(true);
    }

    start()
    {
        this.pos = this.node.worldPosition.clone();
        this.rot = this.node.eulerAngles.clone();
    }

    update(dt:number)
    {
        if(this.target && this.target.parent)
        {
            this.out.x = this.pos.x + this.target.worldPosition.x;
            this.out.y = this.pos.y + this.target.worldPosition.y;
            this.out.z = this.pos.z + this.target.worldPosition.z;

            if (Vec3.distance(this.out,this.node.worldPosition)>30)
            {
                Vec3.lerp(this.out,this.node.worldPosition,this.out,1);
            }else
            {
                Vec3.lerp(this.out,this.node.worldPosition,this.out,0.1);
            }
            this.node.worldPosition=this.out;
        }
    }

}
