import { _decorator, Component, Node,Touch, director, Vec2 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('JoyStick')
export class JoyStick extends Component
{
    @property(Node)
    joy:Node=null;
    @property(Node)
    joyBg:Node=null;

    guideTipNode:Node;
    isShowedGuideTip:boolean = false;

    joyBegin:Vec2;

    start()
    {
        // this.guideTipNode = this.joyBg.getChildByName('GuideTip')
        cc.systemEvent.on(cc.SystemEventType.TOUCH_START,  this.onTouchStart, this);
        cc.systemEvent.on(cc.SystemEventType.TOUCH_MOVE ,  this.onTouchMoved, this);
        cc.systemEvent.on(cc.SystemEventType.TOUCH_END  ,  this.onTouchEnded, this);
        cc.systemEvent.on(cc.SystemEventType.TOUCH_CANCEL, this.onTouchEnded, this);
        this.joy.active = false;
        this.joyBg.active = false;
    }

    onTouchStart(touch:Touch)
    {
        this.isShowedGuideTip = true;

        let offset = cc.v2(cc.winSize.width/2,cc.winSize.height/2);
        this.joyBegin = touch.getUILocation().subtract(offset);
        
        this.joyBg.setPosition(this.joyBegin.x,this.joyBegin.y,0);
        this.joy.setPosition(0,0,0);
    }
    onTouchMoved(touch:Touch)
    {
        this.joy.active = true;
        this.joyBg.active = true;

        let offset = cc.v2(cc.winSize.width/2,cc.winSize.height/2);
        let pos = touch.getUILocation().subtract(offset);
        let deltaX = pos.x - this.joyBegin.x;
        let deltaY = pos.y - this.joyBegin.y;
        let angle = Math.atan2(deltaX,deltaY) * 180 / Math.PI;

        
        let dx = deltaX * deltaX;
        let dy = deltaY * deltaY;
        let ri = this.joyBg.width/2//滑动半径
        if(dx+dy >= ri*ri)
        {
            let radians = Math.PI / 180 * angle;
            let x = Math.floor(Math.sin(radians) * ri);
            let y = Math.floor(Math.cos(radians) * ri);
            this.joy.setPosition(x,y,0);
        }else
        {
            this.joy.setPosition(deltaX,deltaY,0);
        }
        if (Math.abs(deltaX) > 20 || Math.abs(deltaY) > 20)
        {
            director.getScene().emit('MOVE_PLAYER',true,angle);
        }
    }
    onTouchEnded(touch:Touch)
    {
        this.joy.active = false;
        this.joyBg.active = false;
        director.getScene().emit('MOVE_PLAYER',false,null);
    }

    onDestroy()
    {
        cc.systemEvent.off(cc.SystemEventType.TOUCH_START,  this.onTouchStart, this);
        cc.systemEvent.off(cc.SystemEventType.TOUCH_MOVE ,  this.onTouchMoved, this);
        cc.systemEvent.off(cc.SystemEventType.TOUCH_END  ,  this.onTouchEnded, this);
        cc.systemEvent.off(cc.SystemEventType.TOUCH_CANCEL, this.onTouchEnded, this);
    }
}
