import { _decorator, Component, find, instantiate, Node, Prefab, resources, Sprite, SpriteFrame } from 'cc';
import { loadBundle } from './loadBundle';
const { ccclass, property } = _decorator;

@ccclass('Load')
export class Load extends Component {

    start() {
        this.init();
    }

    init() {
        let oldId = 0
        let rongqi = find('Canvas/rongqi')
        // Button1 - 销毁 Sprite1
        let Button1 = find('Canvas/Button1');
        if (Button1) {
            Button1.on(Node.EventType.TOUCH_END, (event) => {
                let cjid = 1
                if (oldId == cjid) {
                    console.log('点击同一个按钮2次')
                    return
                }
                console.log('Button1 点击');
                rongqi.destroyAllChildren()
                loadBundle.init(cjid, () => {
                    this.loadprefab('tu1', rongqi, (_node) => {
                        oldId = cjid
                        var node1 = _node
                        node1.name = 'tu1'
                        let SpriteCom = find('Canvas/rongqi/tu1/Sprite').getComponent(Sprite)
                        loadBundle.loadBundleImg(cjid, "cl251" + '/spriteFrame', (spriteFrame) => {
                            SpriteCom.spriteFrame = spriteFrame
                        })
                    },-200)
                },)
            }, this);
        }

        // Button2 - 加载 SpriteFrame
        let Button2 = find('Canvas/Button2');
        Button2.on(Node.EventType.TOUCH_END, () => {
            let cjid = 2
            if (oldId == cjid) {
                console.log('点击同一个按钮2次')
                return
            }
            console.log('Button2 点击');
            rongqi.destroyAllChildren()
            loadBundle.init(cjid, () => {
                this.loadprefab('tu2', rongqi, (_node) => {
                    oldId = cjid
                    var node1 = _node
                    node1.name = 'tu2'
                    let SpriteCom = find('Canvas/rongqi/tu2/Sprite').getComponent(Sprite)
                    loadBundle.loadBundleImg(cjid, "cl442" + '/spriteFrame', (spriteFrame) => {
                        SpriteCom.spriteFrame = spriteFrame
                    })
                },200)
            })
        }, this);

    }

    loadprefab(prefabName, rongqi, callBack,x) {
        resources.load(`prefab/${prefabName}`, Prefab, (err, prefab) => {
            //console.log("loadPrefabErr",err)
            var node1 = instantiate(prefab)
            node1.parent = rongqi
            node1.setPosition(x, 0)
            callBack(node1);
        });
    }


}