import { _decorator, assetManager, Component, Node, SpriteFrame } from 'cc';
const { ccclass, property } = _decorator;
const names = { 1: "textures1", 2: "textures2" }
@ccclass('loadBundle')
export class loadBundle {
    static init(changjing, _func) {
        let name = names[changjing]
        assetManager.loadBundle(name, {
            version: null,
            cacheEnabled: false,
            onFileProgress: (loaded: any) => {
                var jingdu = Math.floor(loaded.progress)
                var now = Math.floor(loaded.totalBytesWritten / 1024 / 1024)
                var max = Math.floor(loaded.totalBytesExpectedToWrite / 1024 / 1024)
                if (max > 0) {
                }
            }
        }, (err, bundle) => {
            if (!err) {
                _func(bundle)
            } else {
                console.error(err)
                // this.rsLlabeltxt('Label2', `加载资源包${bundleType}出现问题`, this.barJingdu)
            }
        })
    }

    static loadBundleImg(cjid, path, callBack) {
        let name = names[cjid]
        let bundle = assetManager.getBundle(name)
        if (bundle) {
            bundle.load(path, SpriteFrame, (err, spriteFrame) => {
                // console.log("777777", err)
                callBack(spriteFrame);
            });
        } else {
            loadBundle.init(cjid, (bundle) => {
                bundle.load(path, SpriteFrame, (err, spriteFrame) => {
                    // console.log("88888888", err)
                    callBack(spriteFrame);
                });
            })
        }
    }

    static deleteOld(oldId) {
        if (oldId <= 0) {
            return
        }
        let name = names[oldId]
        console.log('旧的名称', name)
        // 释放指定 Bundle 的所有资源
        let bundle = assetManager.getBundle(name)
        bundle?.releaseAll();
        // 或者通过 assetManager 直接释放
        if (bundle) {
            assetManager.removeBundle(bundle);
        } else {
            console.log('bundle不存在')
        }
    }
}


