@cc._decorator.ccclass
export default class Main extends cc.Component {
    protected start(): void {
        const btns = this.node.getChildByName("btns").children;

        // 1 常规点击，会按矩形区域，点到最上面的
        // for (const btn of btns) {
        //     btn.on(cc.Node.EventType.TOUCH_START, (evt: cc.Event.EventTouch) => {
        //         console.log(evt.target);
        //     });
        // }


        // 2 像素级检测，从上到下
        const bundle = cc.assetManager.getBundle("b1");
        const 碰撞信息s: { [key: string]: Uint8Array } = {};
        bundle.loadDir("Texture", cc.BufferAsset, (err, assets) => {
            for (const asset of assets) {
                碰撞信息s[bundle.getAssetInfo(asset["_uuid"]).path.match(/[^\/]+$/)[0]] = new Uint8Array(asset["_buffer"]);
            }
        });
        const resolution = 4;
        const out = new cc.Vec2(0, 0);
        this.node.getChildByName("area").on(cc.Node.EventType.TOUCH_START, (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            let i: number = btns.length;
            while (i--) {
                const btn = btns[i];
                const 碰撞信息 = 碰撞信息s[btn.name];
                const rect = btn.getComponent(cc.Sprite).spriteFrame.getRect();
                const w = Math.ceil(rect.width / resolution);
                const h = Math.ceil(rect.height / resolution);
                btn.convertToNodeSpaceAR(p, out);
                const x = Math.round(w / 2 + out.x / resolution);
                const y = Math.round(h / 2 - out.y / resolution);
                if (x > -1 && x < w && y > -1 && y < h) {
                    const offset = y * w + x;
                    if (碰撞信息[offset >> 3] & (1 << (offset & 0x07))) {
                        console.log("点到了 " + btn.name);
                        return;
                    }
                }
            }
            console.error("啥也没点到！");
        });
    }
}
