const fs = require("fs");
const sharp = require("sharp");//npm install sharp
//console.log(process.argv);

doo([
  "D:/wamp/www/qimiaosenlin/PixelHit/assets/b1/Texture/test/",
  "D:/wamp/www/qimiaosenlin/PixelHit/assets/b1/Texture/HelloWorld.png"
]);

async function doo(paths) {
  let stat;
  for (const path of paths) {
    try {
      stat = fs.statSync(path);
    } catch (e) {
      console.error(e);
      stat = null;
    }
    if (stat) {
      if (stat.isDirectory()) {
        for (const filePath of fs.readdirSync(path, { recursive: true })) {
          if (filePath.endsWith(".png")) {
            await 像素级碰撞区域(path + filePath);
          }
        }
      } else if (stat.isFile()) {
        await 像素级碰撞区域(path);
      }
    }
  }
}
async function 像素级碰撞区域(pngPath) {
  console.log("解析：" + pngPath);
  const resolution = 4;//分辨率，越小越精确（同时信息文件越大）
  const img = await sharp(pngPath);
  const metadata = await img.metadata();
  const width = Math.ceil(metadata.width / resolution);
  const height = Math.ceil(metadata.height / resolution);
  await img.resize(width, height);
  img.ensureAlpha();
  img.toColourspace("srgb");
  const rgbas = await img.raw().toBuffer();
  img.destroy();
  const data = new Uint8Array(Math.ceil(width * height / 8));//存成一个个二进制文件了，当然也可以搞一堆 number[] 存到一整个 json 里，怎么用方便怎么来
  let shift = -1;
  let index = 0;
  for (let y = 0; y < height; y++) {
    const offset = y * width;
    for (let x = 0; x < width; x++) {
      const i = offset + x << 2;
      if (++shift < 8) { } else {
        shift = 0;
        index++;
      }
      if (rgbas[i + 3] > 100) {//透明度 0~255，这里大于 100 算能碰到
        data[index] |= 1 << shift;
      }
    }
  }
  const binPath = pngPath.replace(/\.png$/, ".bin");
  fs.writeFileSync(binPath, Buffer.from(data));
  console.log("生成至：" + binPath);
}