import { _decorator, Component, Node, RigidBody, NodeEventType, Vec3, EditBox, EventTouch, director, Director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    @property(RigidBody)
    ball: RigidBody = null;

    @property(Node)
    canvas: Node = null;

    @property(EditBox)
    edit: EditBox = null;

    public lv: Vec3 = new Vec3();

    start() {
        this.canvas.on(NodeEventType.TOUCH_START, () => {
            this.ball.applyImpulse(new Vec3(0, parseFloat(this.edit.string.trim()), 0));
        });

        director.on(Director.EVENT_BEFORE_PHYSICS, this.onEventBeforePhysicsHandler, this);
    }

    update(deltaTime: number) {
        
    }

    protected btnReset(event: EventTouch, cdata: string) : void
    {
        this.ball.node.setPosition(new Vec3(0, 0, 1));
        this.ball.clearState();
    }

    protected onEventBeforePhysicsHandler() : void
    {
        this.ball.getLinearVelocity(this.lv);
    }
}

