import { _decorator, Component, Node, RigidBody, MeshCollider, ICollisionEvent, Vec3 } from 'cc';
import { test } from './test';
const { ccclass, property } = _decorator;

@ccclass('test1')
export class test1 extends Component {
    @property(String)
    id: String = '1';

    @property(test)
    test: test = null;

    start() {
        this.node.getComponent(RigidBody).useCCD = true;

        this.node.getComponent(MeshCollider).on('onCollisionEnter', this.onCollisionEnter, this);
        this.node.getComponent(MeshCollider).on('onCollisionExit', this.onCollisionExit, this);
    }

    update(deltaTime: number) {
        
    }

    /**
     * @override
     * 碰撞回调
     * @param event 
     */
    protected onCollisionEnter(event: ICollisionEvent) : void
    {
        let lv = new Vec3();
        event.otherCollider.getComponent(RigidBody).getLinearVelocity(lv);
        console.log(this.id + ' 碰撞Enter速度', lv.x, lv.y, lv.z, ' ---- ', this.test.lv.x, this.test.lv.y, this.test.lv.z);
    }

    /**
     * @override
     * 碰撞回调
     * @param event 
     */
    protected onCollisionExit(event: ICollisionEvent) : void
    {
        let lv = new Vec3();
        event.otherCollider.getComponent(RigidBody).getLinearVelocity(lv);
        console.log(this.id + ' 碰撞Exit速度', lv.x, lv.y, lv.z);
    }


}

