
import { _decorator, Component, Node, Texture2D, director, MeshBuffer, utils, gfx, ModelComponent, renderer, Material, builtinResMgr, Asset, EffectAsset, Vec4, CCBoolean, effects, Color, MeshRenderer, Mesh, view } from 'cc';
const { ccclass, property, executeInEditMode } = _decorator;



@ccclass('sprite_plane')
@executeInEditMode(true)
export class sprite_plane extends Component {
    @property({ type: Texture2D, serializable: true, visible: false })
    private _tex: Texture2D = null;
    @property({ type: Texture2D })
    private get tex() {
        return this._tex;
    }
    private set tex(value) {
        if (this._tex !== value) {
            this._tex = value;
            this.init();
        }
    }

    private material: Material = null;
    private model: renderer.scene.Model;

    onEnable() {
        this.init();
    }
    private init() {
        if (!(this.tex instanceof Texture2D)) {
            this.detachFromScene();
            this.material = null;
            this.model = null;
            return;
        }
        this.createModel();
        this.attachToScene();
        this.setMatProperty();
    }
    onDisable() {
        this.detachFromScene();

    }
    private setMatProperty() {
        if (this.material) {
            this.material.setProperty('mainTexture', this.tex);
        }
    }
    private attachToScene() {
        if (this.model && this.node && this.node.scene) {
            if (this.model.scene) {
                this.detachFromScene();
            }
            this._getRenderScene().addModel(this.model);
        }
    }
    private detachFromScene() {
        if (this.model && this.model.scene) {
            this.model.scene.removeModel(this.model);
        }
    }
    private createModel() {
        if (this.model) return;
        if (!this.tex) return;
        const { width, height } = this.tex;
        const designRatio = width / view.getDesignResolutionSize().width;
        const hRatio = designRatio * height / width;
        const mesh = utils.createMesh({
            positions: [
                -designRatio, -hRatio, 0,
                designRatio, -hRatio, 0,
                -designRatio, hRatio, 0,
                designRatio, hRatio, 0],
            uvs: [0, 1,
                1, 1,
                0, 0,
                1, 0],
            indices: [
                0, 1, 2,
                2, 1, 3
            ]
        }, undefined, { calculateBounds: true });
        this.model = director.root.createModel(renderer.scene.Model)
        this.model.node = this.model.transform = this.node;
        if (!this.material) {
            this.material = new Material();
            this.material.initialize({
                technique:0,
                effectAsset: EffectAsset.get('unlit'),
                defines: { USE_TEXTURE: true, USE_ALPHA_TEST: true }
            })
        }
        this.model.initSubModel(0, mesh.renderingSubMeshes[0], this.material);
        this.model.createBoundingShape(mesh.struct.minPosition, mesh.struct.maxPosition);
    }


}
