import { _decorator, Component, Node, EventTouch, Label, resources, JsonAsset } from 'cc';
import * as i18n from './plugin/LanguageData';
//预先定义全局变量：语种列表挂载
const win = window as any;
if (!window['languages']) {
    window['languages'] = {};
}

const { ccclass, property } = _decorator;

@ccclass('game')
export class game extends Component {

    @property(Label)
    testLab: Label = null;

    start() {
        resources.loadDir('lan', JsonAsset, (err: Error, assets: JsonAsset[]) => {
            if (err) {
                console.error('load lan dir err:', err);
                return;
            }
            for (let i = 0; i < assets.length; i++) {
                console.warn('load lan name:', assets[i]);
                window['languages'][assets[i].name] = assets[i].json;
                //以下代码仅作为语种简写和名称的说明，实际是不需要的，如果有对语种文本需要特殊处理的才会用到
                switch (assets[i].name) {
                    default: break;
                    case 'ar'://阿拉伯语

                        break;
                    case 'bn'://孟加拉语

                        break;
                    case 'de'://德语

                        break;
                    case 'en'://英语

                        break;
                    case 'fi'://芬兰语

                        break;
                    case 'fr'://法语

                        break;
                    case 'hi'://印地语

                        break;
                    case 'id'://印尼语

                        break;
                    case 'it'://意大利语

                        break;
                    case 'ja'://日语

                        break;
                    case 'ko'://韩语/朝鲜语

                        break;
                    case 'lo'://老挝语

                        break;
                    case 'ms'://马来语

                        break;
                    case 'nl'://荷兰语

                        break;
                    case 'pt'://葡萄牙语

                        break;
                    case 'ru'://俄语

                        break;
                    case 'sv'://瑞典语

                        break;
                    case 'sw'://斯瓦西里语

                        break;
                    case 'th'://泰语

                        break;
                    case 'tr'://土耳其语

                        break;
                    case 'ur'://乌尔都语

                        break;
                    case 'vi'://越南语

                        break;
                    case 'zh-Hant'://中文繁体

                        break;
                    case 'zh'://中文简体

                        break;

                }
            }
        })
    }
    onLanBtnClick(e: EventTouch, d: string) {
        i18n.init(d);
        i18n.updateSceneRenderers();
    }
    update(deltaTime: number) {

    }
}


