import { director } from 'cc';

export let _curLan = 'EN';

export let ready: boolean = false;

/**
 * 初始化
 * @param language 
 */
export function init(language: string) {
    ready = true;
    _curLan = language;
}

/**
 * 翻译数据
 * @param key 
 */
export function t(key: string) {
    if (!window['languages']) {
        return key;
    }
    let data = window['languages'][_curLan][key];
    console.log('key:', key, ',_curLan:', _curLan, ',data:', data);
    return data || '';
}

export function updateSceneRenderers() { // very costly iterations
    const rootNodes = director.getScene()!.children;
    // 遍历 localizedLabel 组件并更新显示
    const allLocalizedLabels: any[] = [];
    for (let i = 0; i < rootNodes.length; ++i) {
        let labels = rootNodes[i].getComponentsInChildren('LocalizedLabel');
        Array.prototype.push.apply(allLocalizedLabels, labels);
    }
    for (let i = 0; i < allLocalizedLabels.length; ++i) {
        let label = allLocalizedLabels[i];
        if (!label.node.active) continue;
        label.updateLabel();
    }
    // 遍历 localizedSprite 组件并更新显示
    const allLocalizedSprites: any[] = [];
    for (let i = 0; i < rootNodes.length; ++i) {
        let sprites = rootNodes[i].getComponentsInChildren('LocalizedSprite');
        Array.prototype.push.apply(allLocalizedSprites, sprites);
    }
    for (let i = 0; i < allLocalizedSprites.length; ++i) {
        let sprite = allLocalizedSprites[i];
        if (!sprite.node.active) continue;
        sprite.updateSprite();
    }
}

// 供插件查询当前语言使用
const win = window as any;
win._languageData = {
    /**
     * 获取当前语言代码 (如 'en'/'cn')
     */
    get language() {
        return _curLan;
    },
    /**
     * 初始化语言设置
     * @param lang 语言代码 (如 'en'/'cn')，设置后会触发场景组件更新
     */
    init(lang: string) {
        init(lang);
    },
    /**
     * 更新场景渲染
     */
    updateSceneRenderers() {
        updateSceneRenderers();
    },
};