import * as i18n from './LanguageData';
import { _decorator, CCInteger, Component, isValid, Label, Node } from 'cc';
const { ccclass, property, executeInEditMode } = _decorator;

@ccclass('LocalizedLabel')
@executeInEditMode
export class LocalizedLabel extends Component {
    label: Label | null = null;

    @property({ visible: false })
    key: string = '';

    @property({ displayName: 'Key', visible: true })

    get _key() {
        return this.key;
    }
    set _key(str: string) {
        this.key = str;
        this.updateLabel();
    }

    @property(CCInteger)
    num: number = -1;
    set _num(num: number) {
        this.num = num;
        LogMgr.log('LocalizedLabel,num:', num);
        this.updateLabel();
    }


    onLoad() {
        if (!i18n.ready) {
            i18n.init('EN');
        }
        this.fetchRender();
    }
	//搜索并设置文本组件
    fetchRender() {
        let label = this.getComponent('cc.Label') as Label;
        if (label) {
            this.label = label;
            this.updateLabel();
            return;
        }
    }
	//更新文本显示
    updateLabel() {
        this.label && (this.label.string = i18n.t(this.key) + (this.num > 0 ? `${this.num}` : ''));
    }
    //设置末尾的数值
    setEndNum(num: number) {
        if (!isValid(this.label)) { return; }
        this.label.string = i18n.t(this.key) + num;
    }
    //设置前置的数值
    setPreNum(num: number) {
        if (!isValid(this.label) || !num) { return; }
        this.label.string = num + ' ' + i18n.t(this.key);
    }
}
