System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, director, _crd, _curLan, ready, win;

  /**
   * 初始化
   * @param language 
   */
  function init(language) {
    _export("ready", ready = true);

    _export("_curLan", _curLan = language);
  }
  /**
   * 翻译数据
   * @param key 
   */


  function t(key) {
    if (!window['languages']) {
      return key;
    }

    var data = window['languages'][_curLan][key];
    console.log('key:', key, ',_curLan:', _curLan, ',data:', data);
    return data || '';
  }

  function updateSceneRenderers() {
    // very costly iterations
    var rootNodes = director.getScene().children; // 遍历 localizedLabel 组件并更新显示

    var allLocalizedLabels = [];

    for (var i = 0; i < rootNodes.length; ++i) {
      var labels = rootNodes[i].getComponentsInChildren('LocalizedLabel');
      Array.prototype.push.apply(allLocalizedLabels, labels);
    }

    for (var _i = 0; _i < allLocalizedLabels.length; ++_i) {
      var label = allLocalizedLabels[_i];
      if (!label.node.active) continue;
      label.updateLabel();
    } // 遍历 localizedSprite 组件并更新显示


    var allLocalizedSprites = [];

    for (var _i2 = 0; _i2 < rootNodes.length; ++_i2) {
      var sprites = rootNodes[_i2].getComponentsInChildren('LocalizedSprite');

      Array.prototype.push.apply(allLocalizedSprites, sprites);
    }

    for (var _i3 = 0; _i3 < allLocalizedSprites.length; ++_i3) {
      var sprite = allLocalizedSprites[_i3];
      if (!sprite.node.active) continue;
      sprite.updateSprite();
    }
  } // 供插件查询当前语言使用


  _export({
    init: init,
    t: t,
    updateSceneRenderers: updateSceneRenderers
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      director = _cc.director;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "47b4frZjnpH168NQGzolYV8", "LanguageData", undefined);

      __checkObsolete__(['director']);

      _export("_curLan", _curLan = 'EN');

      _export("ready", ready = false);

      win = window;
      win._languageData = {
        /**
         * 获取当前语言代码 (如 'en'/'cn')
         */
        get language() {
          return _curLan;
        },

        /**
         * 初始化语言设置
         * @param lang 语言代码 (如 'en'/'cn')，设置后会触发场景组件更新
         */
        init(lang) {
          init(lang);
        },

        /**
         * 更新场景渲染
         */
        updateSceneRenderers() {
          updateSceneRenderers();
        }

      };

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=5282ec6ca6582b4b74fe97a7abc7a7d7a1981d49.js.map