// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        const graphics = cc.find('Canvas/Node').getComponent(cc.Graphics);
        const rowAndCol = 5;
        const originX = -300 / 2;
        const originY = 300 / 2;
        const blockWidth = 300 / 5;
        const blockHeight = 300 / 5;
        for (let i = 0; i < 5; i++) {
            graphics.moveTo(originX, originY - i * blockHeight);
            graphics.lineTo(originX + 300, originY - i * blockHeight);
            for (let j = 0; j < 5; j++) {
                graphics.moveTo(originX + j * blockWidth, originY);
                graphics.lineTo(originX + j * blockWidth, originY - 300);
            }
        }
        graphics.stroke();
    }

    // update (dt) {}
}
