const { ccclass } = cc._decorator


@ccclass
export default class Main extends cc.Component {
    protected onLoad(): void {
        this.node.getChildByName('bg').on(cc.Node.EventType.TOUCH_START, this.onBgTouchMove, this)
        this.node.getChildByName('bg').on(cc.Node.EventType.TOUCH_MOVE, this.onBgTouchMove, this)


        const itemNode = this.node.getChildByName('item')

        const boundingBox = itemNode.getBoundingBox()

        const graphicsNode = new cc.Node()
        graphicsNode.parent = itemNode.parent

        const graphics = graphicsNode.addComponent(cc.Graphics)
        graphics.strokeColor = cc.Color.RED
        graphics.lineWidth = 2
        graphics.rect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height)
        graphics.stroke()
    }


    private onBgTouchMove(et: cc.Event.EventTouch) {
        const worldPos = et.getLocation()

        for (const node of this.node.children) {
            if (node.name == 'item' && node.getBoundingBoxToWorld().contains(worldPos)) {
                cc.log('在 item 节点上')
            }
        }
    }
}
