const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Node)
    sprNode: cc.Node = null;

    public readonly subres: string = "res";
    public res: cc.AssetManager.Bundle = null;
    start() {
        // init logic
        this.label.string = this.text;

        cc.assetManager.loadBundle(this.subres, (err, bundle) => {
            this.res = bundle;
            console.log("加载成功：", this.subres, this.res);
        });
    }

    onBtnClick() {
        for (let i = 0; i < this.sprNode.childrenCount; i++) {
            let sprChild = this.sprNode.children[i];
            let url = `ic_${i + 1}`;
            this.load(url, sprChild);
        }
    }

    private load(url: string, sprIcon: cc.Node) {
        this.res.load(url, cc.SpriteFrame, (err: Error, spriteFrame: cc.SpriteFrame) => {
            if (err) {
                console.error("load error：", err);
                return;
            }
            if (!cc.isValid(sprIcon)) {
                console.error("sprIcon isValid");
                return;
            }
            sprIcon.getComponent(cc.Sprite).spriteFrame = spriteFrame;
        });
    }
}
