/*
 * @Description: scrollview  demo
 * @Author: Manner
 * @Date: 2021-03-11 12:02:51
 * @LastEditTime: 2021-03-11 13:51:02
 */

const {ccclass, property} = cc._decorator;

@ccclass
export default class MainScene extends cc.Component {

    /**@description content当前停止位置 */
    public contetStopPosY: number = 0;
    /**@description 最大创建Item个数 */
    public foodItemMaxShowNum: number = 15;
    public scrollview: cc.Node = null;
    public content: cc.Node = null;
    public maxItem: number = 1000;
    
    onLoad() {
        this.scrollview = this.node.getChildByName(`scrollview`);
        this.content = this.scrollview.getChildByName(`view`).getChildByName(`content`);
    }

    start () {
        const item = this.node.getChildByName(`sprite_item`);
        this.content.height = (item.height + 10) * this.foodItemMaxShowNum;
        let posY = -item.height / 2 - 10;
        for (let i = 0;i < this.foodItemMaxShowNum;++ i) {
            const cloneItem = cc.instantiate(item);
            cloneItem.parent = this.content;
            cloneItem.active = true;
            this.updateItem(cloneItem, i, posY);
            posY -= item.height + 10;            
        }
    }

    updateItem(item: cc.Node, index: number, posY?: number) {
        (posY && posY != 0) && (item.y = posY);
        item[`index`] = index;
        item.getChildByName(`lab_num`).getComponent(cc.Label).string = `第${index + 1}个`;
    }

    updateRewardItem() {
        let content = this.content;
        let children = content.children;
        if (children.length >= this.foodItemMaxShowNum) { 
            let len = children.length;
            let curIndex = children[len - 1][`index`] + 1;
            if (content.y - this.contetStopPosY > 0 && curIndex < this.maxItem) { // 往上滑动
                let pos = content.convertToWorldSpaceAR(children[0].position);
                let pos1 = this.scrollview.convertToNodeSpaceAR(pos);
                if (pos1.y >= children[0].height + 30) {
                    this.updateItem(children[0], children[len - 1][`index`] + 1, children[len - 1].y - children[0].height - 10);
                    let item = children[0];
                    children[0].parent = null;
                    item.parent = content;
                }
                content.height += content.y - this.contetStopPosY;
                this.contetStopPosY = content.y;
            }
            else if (content.y - this.contetStopPosY < 0 && (children[0][`index`] - 1) >= 0) { // 往下拉
                let pos = content.convertToWorldSpaceAR(children[len - 1].position);
                let pos1 = this.scrollview.convertToNodeSpaceAR(pos);
                if (pos1.y <= -(this.scrollview.height + children[0].height)) {
                    this.updateItem(children[len - 1], children[0][`index`] - 1, children[0].y + children[0].height + 10);
                    let item = children[len - 1];
                    item.parent = null;
                    content.insertChild(item, 0);
                }
                content.height += content.y - this.contetStopPosY;
                this.contetStopPosY = content.y;
            }
        }
    }

    update () {
        if (this.content.children.length > 0) this.updateRewardItem();
    }
}
