/*
 * @Author: Hex
 * @Date: 2024-05-22 16:06:58
 * @LastEditors: Hex
 * @LastEditTime: 2024-05-22 16:41:08
 * @Description: file content
 */
import { _decorator, Component, ImageAsset, Node, resources, Sprite, SpriteFrame, Texture2D } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('LoadSinglePNG')
export class LoadSinglePNG extends Component {
    @property({type: String})
    public assetName: string = "sprites/testPixel";

    @property({type: Node})
    public node512: Node|null = null;
    @property({type: String})
    public png512: string = "512_pixels";

    @property({type: Node})
    public node256: Node|null = null;
    @property({type: String})
    public png256: string = "256_pixels";
    
    @property({type: Node})
    public node32: Node|null = null;
    @property({type: String})
    public png32: string = "32_pixels";

    
    @property({type: Node})
    public node1: Node|null = null;
    @property({type: String})
    public png2: string = "1_pixels";
    start() {
        this.scheduleOnce(()=>{this.load2();}, 2);
        this.scheduleOnce(()=>{this.load32();}, 4);
        this.scheduleOnce(()=>{this.load256();}, 6);
        this.scheduleOnce(()=>{this.load512();}, 8);
    }

    update(deltaTime: number) {
        
    }

    public load256(){
        const resourceStartTime = Date.now();
        
        const path = `${this.assetName}/${this.png256}`;
        resources.load(path, ImageAsset, (err, imageAsset: ImageAsset) => {
            if (err) {
                console.error(`Failed to load image: ${path}`, err);
                return;
            }
            const resourceEndTime = Date.now();
            const loadTime = resourceEndTime - resourceStartTime;
            console.log(`图片资源 ${path} 加载时间: ${loadTime} ms`);

            // 创建纹理并应用
            const texture = new Texture2D();
            texture.image = imageAsset;
            const spriteFrame = new SpriteFrame();
            spriteFrame.texture = texture;

            this.node256!.getComponent(Sprite)!.spriteFrame = spriteFrame;
        });
    }
    
    public load512(){
        const resourceStartTime = Date.now();
        
        const path = `${this.assetName}/${this.png512}`;
        resources.load(path, ImageAsset, (err, imageAsset: ImageAsset) => {
            if (err) {
                console.error(`Failed to load image: ${path}`, err);
                return;
            }
            const resourceEndTime = Date.now();
            const loadTime = resourceEndTime - resourceStartTime;
            console.log(`图片资源 ${path} 加载时间: ${loadTime} ms`);

            // 创建纹理并应用
            const texture = new Texture2D();
            texture.image = imageAsset;
            const spriteFrame = new SpriteFrame();
            spriteFrame.texture = texture;

            this.node512!.getComponent(Sprite)!.spriteFrame = spriteFrame;
        });
    }



    public load32(){
        const resourceStartTime = Date.now();

        const path = `${this.assetName}/${this.png32}`;
        resources.load(path, ImageAsset, (err, imageAsset: ImageAsset) => {
            if (err) {
                console.error(`Failed to load image: ${path}`, err);
                return;
            }
            const resourceEndTime = Date.now();
            const loadTime = resourceEndTime - resourceStartTime;
            console.log(`图片资源 ${path} 加载时间: ${loadTime} ms`);

            // 创建纹理并应用
            const texture = new Texture2D();
            texture.image = imageAsset;
            const spriteFrame = new SpriteFrame();
            spriteFrame.texture = texture;

            this.node32!.getComponent(Sprite)!.spriteFrame = spriteFrame;
        });
    }

    public load2(){
        const resourceStartTime = Date.now();

        const path = `${this.assetName}/${this.png2}`;
        resources.load(path, ImageAsset, (err, imageAsset: ImageAsset) => {
            if (err) {
                console.error(`Failed to load image: ${path}`, err);
                return;
            }
            const resourceEndTime = Date.now();
            const loadTime = resourceEndTime - resourceStartTime;
            console.log(`图片资源 ${path} 加载时间: ${loadTime} ms`);

            // 创建纹理并应用
            const texture = new Texture2D();
            texture.image = imageAsset;
            const spriteFrame = new SpriteFrame();
            spriteFrame.texture = texture;

            this.node1!.getComponent(Sprite)!.spriteFrame = spriteFrame;
        });
    }
}


