import { _decorator, Asset, sys } from 'cc';
import { UIPackage } from 'fairygui-cc';
import { CocosEntry, FrameConfig, GlobalEvent, log, Platform, WindowManager } from 'kunpocc';
import { AssetLoader } from './AssetHelper';
import { Debug } from './Debug';
const { ccclass, property, menu } = _decorator;

@ccclass("GameEntry")
@menu("kunpo/GameEntry")
export class GameEntry extends CocosEntry {
    public getConfig(): FrameConfig {
        return {
            debug: true
        };
    }

    onInit(): void {
        let deviceId = sys.localStorage.getItem('xBBres');
        if (!deviceId || deviceId === "") {
            deviceId = "browser@" + Date.now().toString();
            sys.localStorage.setItem('xBBres', deviceId);
        }
        Platform.deviceId = deviceId;

        Debug.Register();
        this.loadResources();
        // fgui.GRoot.create();
        // console.log("游戏开始了");
        // fgui.UIPackage.loadPackage("ui/Home", () => {
        //     console.log("加载成功");
        //     let window = fgui.UIPackage.createObject("Home", "HomeWindow").asCom;
        //     window.makeFullScreen();
        //     fgui.GRoot.inst.addChild(window);
        // });

        // kunpocc.GlobalTimer.startTimer(() => {
        //     kunpocc.Log.info("Hello Kunpo!");
        // }, 1, -1)
    }

    private loadResources(): void {
        let paths = [
            { path: "ui", type: Asset },
        ];
        let loader = new AssetLoader();
        loader.setLoadItems(paths);
        loader.setCallbacks(
            (percent: number) => {

            },
            () => {
                this.loadComplete();
            }
        );
        loader.start();

        // this._resourceLoader("加载基础资源", paths, () => {
        //     TrackDataHelper.onEvent(TrackType.GameInit, { initid: 1, describe: "基础资源加载完成" });
        //     fgui.registerFont('enFont', AssetPool.getAsset<cc.Font>("font/enFont"));
        //     fgui.registerFont('titleFont', AssetPool.getAsset<cc.Font>("font/titleFont"));
        //     fgui.UIConfig.defaultFont = 'titleFont'; // 设置默认字体
        //     fgui.UIConfig.tooltipsWin = 'ui://Basics/ItemDetailsTips'; // 默认浮窗

        //     fgui.UIPackage.addPackage("ui/basics/Basics");
        //     fgui.UIConfig.buttonSound = 'ui://Basics/s_button'; // 设置默认按钮音效
        //     if (kunpo.Platform.isNativeMobile || kunpo.Platform.isHuawei) {
        //         fgui.UIPackage.addPackage("ui/SDK");
        //     }
        //     // 适龄提示按钮
        //     let button_age_tip = this.node.getChildByName("button_age_tip").getComponent(cc.Button);
        //     button_age_tip.interactable = true;
        //     button_age_tip.node.on(cc.Node.EventType.TOUCH_END, () => {
        //         WindowHelper.showWindowIm("ContractDetailsWindow", { title: "适龄提示", filename: "age_tips" });
        //     }, this);
        //     this._inquiryAgreePrivacy();
        // });
    }


    private loadComplete(): void {
        UIPackage.addPackage("ui/Home");
        WindowManager.showWindow("HomeWindow", "这是一个测试窗口");
        // kunpocc.WindowManager.showWindow("PopWindow", "这是一个测试窗口");

        GlobalEvent.add("event::111", () => {
            log("接收到事件");
        }, this);
    }
}