/**
 * @Author: Gongxh
 * @Date: 2024-05-20
 * @Description: 新版鉴权接口
 */

import { Platform } from "kunpocc";
import { INetResponse } from "../header";
import { NetHelper } from "../NetHelper";
import { NetTaskBase } from "../NetTaskBase";

interface IAuthResponse extends INetResponse {
    token: string;
    uid: number;    // 用户id
    sdkId: string;
    channel: number;
    /** 注册渠道 */
    regChannel: number;
}

/** 账户认证 */
export class NetAuth extends NetTaskBase {
    name: string = "NetSocketAuth";
    url: string = '/api/game/auth';
    constructor() {
        super()
    }

    public start(): void {
        let data = {
            channel: 25,
            token: Platform.deviceId,
            openid: Platform.deviceId,
            sdkChannel: 25,
            distinctId: ''
        }
        NetHelper.send(this.url, data, this);
    }

    protected onTaskComplete(data: IAuthResponse): void {

    }

    // /**
    //  * 
    //  * @param {ResponseData} data.packet 数据
    //  * @param {number} data.responseStatus 返回码 0:成功  其他:错误
    //  */
    // protected onNetComplete(data: { packet: ResponseData, responseStatus: number, msg: string }) {
    //     let response = data.packet;
    //     if (response) {
    //         let response = data.packet;
    //         UserHelper.setSocketInfo(response.token, response.uid, response.sdkId, response.channel, response.regChannel);
    //         EventHelper.triggerEvent("event::login::finish");
    //         TrackDataHelper.login(`${response.uid}`);
    //         // let isBanForever = (response.ban_status == 1 && response.open_time == 0);
    //         // let date = new Date(MyHelper.time.now_ms());
    //         // TrackDataHelper.setHeaderInfo({ final_login_time: date, uid: response.uid, isban: isBanForever, ban_status: response.ban_status == 1 });
    //         TrackDataHelper.addHeaderInfo({ loginNum: 1 });
    //         // TrackDataHelper.setEventHeader({ ban_forever: isBanForever, event_ban_times: response.ban_count, ban_status: response.ban_status == 1 });

    //         /** 设置是否是新用户标记 */
    //         // DataHelper.isNew = response.reg == 1;
    //         // if (DataHelper.isNew && WechatHelper.gdtVid) {
    //         //     TrackDataHelper.setHeaderOnce({ gdt_vid: WechatHelper.gdtVid });
    //         //     TrackDataHelper.onEvent(TrackType.MiniGameGdtVid, { gdt_vid: WechatHelper.gdtVid });
    //         // }

    //         if (kunpo.Platform.isNativeMobile && kunpo.Platform.isIOS) {
    //             let login_method = DataHelper.sdkLocalData.getValue(SDKLocalKeys.LoginMethod, LoginMethod.Mobile);
    //             KunpoSDK.SDKHelper.getInstance().updateUserInfo(`${response.uid}`, `${response.uid}`);
    //             KunpoSDK.SDKHelper.getInstance().userLogin();
    //             // 登录结果上报
    //             KunpoSDK.SDKHelper.getInstance().loginRequestResult(login_method);
    //         }
    //     }
    // }
}


