/**
 * @Author: Gongxh
 * @Date: 2024-12-21
 * @Description: 
 */
import { GButton } from 'fairygui-cc';
import * as kunpocc from 'kunpocc';
import { _uidecorator } from 'kunpocc';
const { uiclass, uiprop, uiclick } = _uidecorator;

@uiclass({ group: "Window", pkg: "Home" })
export class CloseAllWindow extends kunpocc.Window {
    private btn_close: GButton;
    protected onInit(): void {
        this.adapterType = kunpocc.AdapterType.Bang;
        this.type = kunpocc.WindowType.CloseAll;

        this.btn_close = this.getChild<GButton>("btn_close");
        this.btn_close.onClick(() => {
            kunpocc.WindowManager.closeWindow(this.name);
        }, this);
    }

    protected onShow(userdata?: any): void {
        kunpocc.log("CloseAllWindow onShow:", userdata);
    }

    protected onHide(): void {
        kunpocc.log("CloseAllWindow onHide");
    }

    protected onCover(): void {
        kunpocc.log("CloseAllWindow onCover");
    }

    protected onRecover(): void {
        kunpocc.log("CloseAllWindow onRecover");
    }

    protected onShowFromHide(): void {
        kunpocc.log("CloseAllWindow onShowFromHide");
    }

    protected onEmptyAreaClick(): void {
        kunpocc.log("CloseAllWindow 点击空白区域");
    }

    protected onClose(): void {
        kunpocc.log("CloseAllWindow onClose");
    }
}
