/**
 * @Author: Gongxh
 * @Date: 2024-12-21
 * @Description: 
 */

import { GButton } from 'fairygui-cc';
import * as kunpocc from 'kunpocc';
import { _uidecorator } from 'kunpocc';
const { uiclass, uiprop, uiclick } = _uidecorator;

@uiclass({ group: "Window", pkg: "Home" })
export class CloseOneWindow extends kunpocc.Window {
    private btn_close: GButton;
    protected onInit(): void {
        this.adapterType = kunpocc.AdapterType.Bang;
        this.type = kunpocc.WindowType.CloseOne;

        this.btn_close = this.getChild<GButton>("btn_close");
        this.btn_close.onClick(() => {
            kunpocc.WindowManager.closeWindow(this.name);
        }, this);
    }

    protected onShow(userdata?: any): void {
        kunpocc.log("CloseOneWindow onShow:", userdata);
    }

    protected onHide(): void {
        kunpocc.log("CloseOneWindow onHide");
    }

    protected onCover(): void {
        kunpocc.log("CloseOneWindow onCover");
    }

    protected onRecover(): void {
        kunpocc.log("CloseOneWindow onRecover");
    }

    protected onShowFromHide(): void {
        kunpocc.log("CloseOneWindow onShowFromHide");
    }

    protected onEmptyAreaClick(): void {
        kunpocc.log("CloseOneWindow 点击空白区域");
    }

    protected onClose(): void {
        kunpocc.log("CloseOneWindow onClose");
    }
}
