/**
 * @Author: Gongxh
 * @Date: 2024-12-11
 * @Description: 
 */

import * as kunpocc from 'kunpocc';
import { _uidecorator } from 'kunpocc';
import { CustomComponents } from './Components/CustomComponents';
const { uiclass, uiprop, uiclick } = _uidecorator;
@uiclass({ group: "Window", pkg: "Home" })
export class HomeWindow extends kunpocc.Window {
    @uiprop customComponents: CustomComponents;
    // @uiprop cccc: GObject;
    // @uiprop(GObject) ccccc: GObject;
    // @uiprop({ type: GObject, name: "dddd" })
    // dddd: string;

    // @uiclick
    protected onInit(): void {
        this.adapterType = kunpocc.AdapterType.Bang;
        this.type = kunpocc.WindowType.Normal;

        this.onClick(() => {
            kunpocc.log("点击 HomeWindow");
        }, this);
    }

    protected onShow(userdata?: any): void {
        kunpocc.log("HomeWindow onShow:", userdata);
    }

    protected onHide(): void {
        kunpocc.log("HomeWindow onHide");
    }

    protected onCover(): void {
        kunpocc.log("HomeWindow onCover");
    }

    protected onRecover(): void {
        kunpocc.log("HomeWindow onRecover");
    }

    protected onShowFromHide(): void {
        kunpocc.log("HomeWindow onShowFromHide");
    }

    protected onEmptyAreaClick(): void {
        kunpocc.log("HomeWindow 点击空白区域");
    }

    protected onClose(): void {
        kunpocc.log("HomeWindow onClose");
    }
}
