/**
 * @Author: Gongxh
 * @Date: 2024-12-14
 * @Description: 
 */

import { GButton } from 'fairygui-cc';
import * as kunpocc from 'kunpocc';
import { _uidecorator } from 'kunpocc';
const { uiclass, uiprop, uiclick } = _uidecorator;

@uiclass({ group: "Toast", pkg: "Home" })
export class PopWindow extends kunpocc.Window {
    private btn_close: GButton;
    protected onInit(): void {
        this.adapterType = kunpocc.AdapterType.Bang;
        this.type = kunpocc.WindowType.Normal;

        this.btn_close = this.getChild<GButton>("btn_close");
        this.btn_close.onClick(() => {
            kunpocc.WindowManager.closeWindow(this.name);
        }, this);
    }

    protected onShow(userdata?: any): void {
        kunpocc.log("PopWindow onShow:", userdata);
    }

    protected onHide(): void {
        kunpocc.log("PopWindow onHide");
    }

    protected onCover(): void {
        kunpocc.log("PopWindow onCover");
    }

    protected onRecover(): void {
        kunpocc.log("PopWindow onRecover");
    }

    protected onShowFromHide(): void {
        kunpocc.log("PopWindow onShowFromHide");
    }

    protected onEmptyAreaClick(): void {
        kunpocc.log("PopWindow 点击空白区域");
    }

    protected onClose(): void {
        kunpocc.log("PopWindow onClose");
    }
}
