import { readFileSync } from 'fs-extra';
import { join } from 'path';
import Vue from 'vue/dist/vue';
// 确保先导入 fgui-view 组件
import '../fgui/fgui-view';
import '../kunpo/kunpo-view';

const panelDataMap = new WeakMap()
module.exports = Editor.Panel.define({
    listeners: {
        show() {
            console.log('show');
        },
        hide() {
            console.log('hide');
        },
    },
    template: readFileSync(join(__dirname, '../../../static/template/default/index.html'), 'utf-8'),
    style: readFileSync(join(__dirname, '../../../static/style/default/index.css'), 'utf-8') +
        readFileSync(join(__dirname, '../../../static/style/fgui/fgui-view.css'), 'utf-8') +
        readFileSync(join(__dirname, '../../../static/style/kunpo/kunpo-view.css'), 'utf-8'),
    $: {
        app: '#app',
    },
    methods: {

    },
    ready() {
        if (this.$.app) {
            console.log('index ready');
            const vm = new Vue({
                el: this.$.app,
            });
            panelDataMap.set(this, vm);
        }
    },
    beforeClose() { },
    close() {
        const vm = panelDataMap.get(this);
        if (vm) {
            vm.$destroy();
        }
    },
});
