
import { _decorator, Component, Node, assetManager, SpriteFrame, Prefab, instantiate, director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('MainGame')
export class MainGame extends Component {
    
    start () {
        let parent = this.node
        this.scheduleOnce(()=>{
            
            assetManager.loadBundle('TestBundle',(err,bundle)=>
            {
                console.log('测试bundle加载完成')
                
                //这里测试 "Bird" 有3.78M 纹理内存无法释放
                //但是测试 "prefab" 却可以释放 为什么?
                bundle.load("Bird", Prefab, function (err, assets) {
                    console.log('资源总量',assets)

                    let node = instantiate(assets)
                    parent.addChild(node)

                    setTimeout(() => {
                        console.log('测试bundle卸载完成')
                        bundle.releaseAll();


                        setTimeout(() => {
                            assetManager.loadBundle('TestScene1',(err,bundle2)=>
                            {
                                if (!err)
                                {
                                    bundle2.loadScene('Scene1', function (err1, scene)
                                    {
                                        director.runScene(scene);

                                        setTimeout(() => {
                                            
                                        }, 1000);
                                    });
                                }
                            })
                        }, 1000);

                    }, 1000);

                });
            })
        },1)
        
    }
}
