import { _decorator, Component, Node, v3, Label, UITransform } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    @property(Node)
    playerNode: Node = null;
    @property(Node)
    diantiNode: Node = null;

    @property(Node)
    pl: Node = null;
    @property(Node)
    pr: Node = null;

    @property(Node)
    du: Node = null;
    @property(Node)
    dd: Node = null;

    @property(Node)
    btn: Node = null;

    start() {
        this.pl.on("click", () => {
            this.playerNode.setPosition(v3(this.playerNode.position.x - 10, this.playerNode.position.y, this.playerNode.position.z));
        }, this);
        this.pr.on("click", () => {
            this.playerNode.setPosition(v3(this.playerNode.position.x + 10, this.playerNode.position.y, this.playerNode.position.z));
        }, this);

        this.du.on("click", () => {
            this.diantiNode.setPosition(v3(this.diantiNode.position.x, this.diantiNode.position.y + 10, this.diantiNode.position.z));
        }, this);
        this.dd.on("click", () => {
            this.diantiNode.setPosition(v3(this.diantiNode.position.x, this.diantiNode.position.y - 10, this.diantiNode.position.z));
        }, this);

        this.btn.on("click", () => {
            if (this.playerNode.parent == this.node) {
                let wp = this.node.getComponent(UITransform).convertToWorldSpaceAR(this.playerNode.position)
                let rp = this.diantiNode.getComponent(UITransform).convertToNodeSpaceAR(wp);
                this.playerNode.parent = this.diantiNode;
                this.playerNode.setPosition(rp);
                this.btn.getChildByName("Label").getComponent(Label).string = "人在电梯上";
            } else {
                let wp = this.diantiNode.getComponent(UITransform).convertToWorldSpaceAR(this.playerNode.position)
                let rp = this.node.getComponent(UITransform).convertToNodeSpaceAR(wp);
                this.playerNode.parent = this.node;
                this.playerNode.setPosition(rp);
                this.btn.getChildByName("Label").getComponent(Label).string = "人不在电梯上";
            }
        }, this);
    }

    update(deltaTime: number) {

    }
}

