
import { _decorator, Component, Node, PhysicsSystem, director, Collider, ITriggerEvent, game, RigidBody, BoxCollider, v3 } from 'cc';

const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    @property(Node)
    moveNode!: Node;
    @property(Node)
    checkNode!: Node;

    private enabledPhyStep = false;
    private timePhyStep: any = 0;

    start() {
        //要动的节点，要加运动刚体，不然内置物理引擎支持，其他物理引擎可能不支持
        const rbAi = this.moveNode.addComponent(RigidBody)!;
        rbAi.type = RigidBody.Type.KINEMATIC;
        rbAi.setGroup(1);
        rbAi.setMask(1);
        let moveCollider = this.moveNode.addComponent(BoxCollider)!;
        moveCollider.isTrigger = true;
        moveCollider.size = v3(1, 1, 1);
        moveCollider.center = v3(0, 0, 0);
        moveCollider.on('onTriggerEnter', (ev: ITriggerEvent) => {
            console.log("move.onTriggerEnter", ev);
        }, this);
        moveCollider.on('onTriggerExit', (ev: ITriggerEvent) => {
            console.log("move.onTriggerExit", ev);
        }, this);

        let checkCollider = this.checkNode.getComponent(Collider)!;
        /*
        checkCollider.on('onTriggerEnter', (ev: ITriggerEvent) => {
            console.log("check.onTriggerEnter", ev);
        }, this);
        checkCollider.on('onTriggerExit', (ev: ITriggerEvent) => {
            console.log("check.onTriggerExit", ev);
        }, this);*/
        checkCollider.setGroup(1);
        checkCollider.setMask(1);

        PhysicsSystem.instance.enable = true;
        PhysicsSystem.instance.autoSimulation = true;
        console.log("autoSimulation:", PhysicsSystem.instance.autoSimulation);
    }
    onClickAutoRender() {
        if (game.isPaused()) {
            game.resume();
            console.log("onClickAutoRender:恢复");
        } else {
            game.pause();
            console.log("onClickAutoRender:暂停");
        }
    }
    onClickAutoPhysicsSystem() {
        this.enabledPhyStep = false;
        if (this.timePhyStep) clearInterval(this.timePhyStep);
        this.timePhyStep = 0;

        PhysicsSystem.instance.autoSimulation = !PhysicsSystem.instance.autoSimulation;
        console.log("autoSimulation:", PhysicsSystem.instance.autoSimulation);
        console.log("停止update自动步进");
        console.log("停止定时器自动步进");
    }

    onClickTestMove() {
        if (this.moveNode.position.x == 1.5) {
            this.moveNode.setPosition(0.5, this.moveNode.position.y, this.moveNode.position.z);
            console.log("移进碰撞区域了, 下面应该到onTriggerEnter");
        } else {
            this.moveNode.setPosition(1.5, this.moveNode.position.y, this.moveNode.position.z);
            console.log("移出碰撞区域了, 下面应该到onTriggerExit");
        }
    }
    onClickPhysicsStep() {

        //这里更新Collider节点的空间信息,需要调用同步到物理世界方法
        PhysicsSystem.instance.physicsWorld.syncSceneToPhysics();
        //手动模拟步进
        PhysicsSystem.instance.physicsWorld.step(10000);//步进时间多少都没有效果
        //触发相关事件
        PhysicsSystem.instance.physicsWorld.emitEvents();
        PhysicsSystem.instance.physicsWorld.syncAfterEvents();
        console.log("onClickPhysicsStep:执行一步");
    }
    onClickTimePhysicsStep() {
        let inv = 1 / 60;
        let dt = inv;

        if (this.timePhyStep) clearInterval(this.timePhyStep);
        console.log("开启定时器自动步进");
        this.timePhyStep = setInterval(() => {
            //这里更新Collider节点的空间信息,需要调用同步到物理世界方法
            PhysicsSystem.instance.physicsWorld.syncSceneToPhysics();
            //手动模拟步进
            PhysicsSystem.instance.physicsWorld.step(dt);
            //触发相关事件
            PhysicsSystem.instance.physicsWorld.emitEvents();
            PhysicsSystem.instance.physicsWorld.syncAfterEvents();
            console.log("onClickPhysicsStep:执行一步");
            //用定时器的方式有概率会触发 触发器
        }, inv);
    }
    onClickStartAutoPhysicsStep() {
        this.enabledPhyStep = true;
        console.log("开启update自动步进");
    }
    update(dt: number) {
        if (this.enabledPhyStep) {
            //这里更新Collider节点的空间信息,需要调用同步到物理世界方法
            PhysicsSystem.instance.physicsWorld.syncSceneToPhysics();
            //手动模拟步进
            PhysicsSystem.instance.physicsWorld.step(dt);
            //触发相关事件
            PhysicsSystem.instance.physicsWorld.emitEvents();
            PhysicsSystem.instance.physicsWorld.syncAfterEvents();
            //在update里步进是百分百触发 触发器
            console.log("onClickPhysicsStep:执行一步");
        }
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
