"use strict";
cc._RF.push(module, '7a2783sZgJFXr4Nn8RLEt+q', 'EXCEL_TO_DB');
// EXCEL_TO_DB.js

"use strict";

// const Polyglot = require('polyglot.min');
var EXCEL_TYPE = require("EXCEL_TYPE"); //var path = require('path');


var keyString = "ckx*xc0125_11"; //xxtea密钥 一般16位（也可以不是16位）
// ArrayBuffer转为字符串，参数为ArrayBuffer对象

function ab2str(buf) {
  return String.fromCharCode.apply(null, new Uint32Array(buf));
} // // 字符串转为ArrayBuffer对象，参数为字符串
// function str2ab(str) {
//     var buf = new ArrayBuffer(str.length*2); // 每个字符占用2个字节
//     var bufView = new Uint8Array(buf);
//     for (var i=0, strLen=str.length; i<strLen; i++) {
//     bufView[i] = str.charCodeAt(i);
//     }
//     return buf;
// }
//----------------------------------------
//ArrayBuffer转字符串 异步
// function ab2str(u,f) {
//    var b = new Blob([u]);
//    var r = new FileReader();
//     r.readAsText(b, 'utf-8');
//     r.onload = function (){if(f)f.call(null,r.result)}
// }
// //字符串转字符串ArrayBuffer
// function str2ab(s,f) {
//     var b = new Blob([s],{type:'text/plain'});
//     var r = new FileReader();
//     r.readAsArrayBuffer(b);
//     r.onload = function (){if(f)f.call(null,r.result)}
// }
//实际调用
// ab2str(arrayBuffer,function(str){
//     //str为字符串
// });
// str2ab(str,function(ab){
//     //ab为ArrayBuffer
// });


function xxtea_encrypt(str) {
  if (str == "") {
    return "";
  }

  str = utf16ToUtf8(str); //如果是中文解析可能会出问题，加密之前先转化为utf8格式

  var v = str2long(str, true);
  var k = str2long(keyString, false);

  if (k.length < 4) {
    k.length = 4;
  }

  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = 0;

  while (0 < q--) {
    sum = sum + delta & 0xffffffff;
    e = sum >>> 2 & 3;

    for (p = 0; p < n; p++) {
      y = v[p + 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      z = v[p] = v[p] + mx & 0xffffffff;
    }

    y = v[0];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    z = v[n] = v[n] + mx & 0xffffffff;
  }

  str = long2str(v, false);
  return encode_base64(str); //加密过后用base64编码
}

function xxtea_decrypt_base64(str) {
  if (str == "") {
    return "";
  }

  str = decode_base64(str);
  var v = str2long(str, false);
  var k = str2long(keyString, false);

  if (k.length < 4) {
    k.length = 4;
  }

  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = q * delta & 0xffffffff;

  while (sum != 0) {
    e = sum >>> 2 & 3;

    for (p = n; p > 0; p--) {
      z = v[p - 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      y = v[p] = v[p] - mx & 0xffffffff;
    }

    z = v[n];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    y = v[0] = v[0] - mx & 0xffffffff;
    sum = sum - delta & 0xffffffff;
  }

  var result = long2str(v, true);
  result = utf8ToUtf16(result);
  return result;
}

function xxtea_decrypt_bytes(bytes) {
  var v = toUint32Array(bytes, false);
  var k = toUint32Array(toBytes(keyString), false);
  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = q * delta & 0xffffffff;

  while (sum != 0) {
    e = sum >>> 2 & 3;

    for (p = n; p > 0; p--) {
      z = v[p - 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      y = v[p] = v[p] - mx & 0xffffffff;
    }

    z = v[n];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    y = v[0] = v[0] - mx & 0xffffffff;
    sum = sum - delta & 0xffffffff;
  }

  var test = toUint8Array(v, true);
  return toString(test);
}

function toShortString(bytes, n) {
  var charCodes = new Array(n);
  var i = 0,
      off = 0;

  for (var len = bytes.length; i < n && off < len; i++) {
    var unit = bytes[off++];

    switch (unit >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        charCodes[i] = unit;
        break;

      case 12:
      case 13:
        if (off < len) {
          charCodes[i] = (unit & 0x1F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 14:
        if (off + 1 < len) {
          charCodes[i] = (unit & 0x0F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 15:
        if (off + 2 < len) {
          var rune = ((unit & 0x07) << 18 | (bytes[off++] & 0x3F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F) - 0x10000;

          if (0 <= rune && rune <= 0xFFFFF) {
            charCodes[i++] = rune >> 10 & 0x03FF | 0xD800;
            charCodes[i] = rune & 0x03FF | 0xDC00;
          } else {
            throw new Error('Character outside valid Unicode range: 0x' + rune.toString(16));
          }
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      default:
        throw new Error('Bad UTF-8 encoding 0x' + unit.toString(16));
    }
  }

  if (i < n) {
    charCodes = charCodes.slice(0, i); //charCodes.subarray(0, i);
  }

  return String.fromCharCode.apply(String, charCodes);
}

function toLongString(bytes, n) {
  var buf = [];
  var charCodes = new Array(0xFFFF);
  var i = 0,
      off = 0;

  for (var len = bytes.length; i < n && off < len; i++) {
    var unit = bytes[off++];

    switch (unit >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        charCodes[i] = unit;
        break;

      case 12:
      case 13:
        if (off < len) {
          charCodes[i] = (unit & 0x1F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 14:
        if (off + 1 < len) {
          charCodes[i] = (unit & 0x0F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 15:
        if (off + 2 < len) {
          var rune = ((unit & 0x07) << 18 | (bytes[off++] & 0x3F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F) - 0x10000;

          if (0 <= rune && rune <= 0xFFFFF) {
            charCodes[i++] = rune >> 10 & 0x03FF | 0xD800;
            charCodes[i] = rune & 0x03FF | 0xDC00;
          } else {
            throw new Error('Character outside valid Unicode range: 0x' + rune.toString(16));
          }
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      default:
        throw new Error('Bad UTF-8 encoding 0x' + unit.toString(16));
    }

    if (i >= 65534) {
      var size = i + 1;
      buf.push(String.fromCharCode.apply(String, charCodes.slice(0, size)));
      n -= size;
      i = -1;
    }
  }

  if (i > 0) {
    buf.push(String.fromCharCode.apply(String, charCodes.slice(0, i)));
  }

  return buf.join('');
}

function toString(bytes) {
  var n = bytes.length;
  if (n === 0) return '';
  return toLongString(bytes, n); //((n < 100000) ? toShortString(bytes, n) : toLongString(bytes, n));
} // byte数组转32位无符号数组


function toUint32Array(bytes, includeLength) {
  var length = bytes.length;
  var n = length >> 2;

  if ((length & 3) !== 0) {
    ++n;
  }

  var v;

  if (includeLength) {
    v = new Array(n + 1);
    v[n] = length;
  } else {
    v = new Uint32Array(n);
  }

  for (var i = 0; i < length; ++i) {
    v[i >> 2] |= bytes[i] << ((i & 3) << 3);
  }

  return v;
} // 32位无符号整数型数组 转 byte数组


function toUint8Array(v, includeLength) {
  var n;

  if (includeLength) {
    n = v[v.length - 1];
  } else {
    n = v.length << 2;
  }

  var result = new Uint8Array(n);

  for (var i = 0; i < n; i++) {
    result[i] = v[i >> 2] >> ((i & 3) << 3);
  }

  return result;
} // str转byte数组


function toBytes(str) {
  var n = str.length; // A single code unit uses at most 3 bytes.
  // Two code units at most 4.

  var bytes = new Uint8Array(n * 3);
  var length = 0;

  for (var i = 0; i < n; i++) {
    var codeUnit = str.charCodeAt(i);

    if (codeUnit < 0x80) {
      bytes[length++] = codeUnit;
    } else if (codeUnit < 0x800) {
      bytes[length++] = 0xC0 | codeUnit >> 6;
      bytes[length++] = 0x80 | codeUnit & 0x3F;
    } else if (codeUnit < 0xD800 || codeUnit > 0xDFFF) {
      bytes[length++] = 0xE0 | codeUnit >> 12;
      bytes[length++] = 0x80 | codeUnit >> 6 & 0x3F;
      bytes[length++] = 0x80 | codeUnit & 0x3F;
    } else {
      if (i + 1 < n) {
        var nextCodeUnit = str.charCodeAt(i + 1);

        if (codeUnit < 0xDC00 && 0xDC00 <= nextCodeUnit && nextCodeUnit <= 0xDFFF) {
          var rune = ((codeUnit & 0x03FF) << 10 | nextCodeUnit & 0x03FF) + 0x010000;
          bytes[length++] = 0xF0 | rune >> 18;
          bytes[length++] = 0x80 | rune >> 12 & 0x3F;
          bytes[length++] = 0x80 | rune >> 6 & 0x3F;
          bytes[length++] = 0x80 | rune & 0x3F;
          i++;
          continue;
        }
      }

      throw new Error('Malformed string');
    }
  }

  return bytes.subarray(0, length);
}

function utf16ToUtf8(str) {
  //utf16转化utf8 解决中文乱码问题 
  var out, i, len, c;
  out = "";
  len = str.length;

  for (i = 0; i < len; i++) {
    c = str.charCodeAt(i);

    if (c >= 0x0001 && c <= 0x007F) {
      out += str.charAt(i);
    } else if (c > 0x07FF) {
      out += String.fromCharCode(0xE0 | c >> 12 & 0x0F);
      out += String.fromCharCode(0x80 | c >> 6 & 0x3F);
      out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
    } else {
      out += String.fromCharCode(0xC0 | c >> 6 & 0x1F);
      out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
    }
  }

  return out;
}

function utf8ToUtf16(str) {
  var out, i, len, c;
  var char2, char3;
  out = "";
  len = str.length;
  i = 0;

  while (i < len) {
    c = str.charCodeAt(i++);

    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += str.charAt(i - 1);
        break;

      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = str.charCodeAt(i++);
        out += String.fromCharCode((c & 0x1F) << 6 | char2 & 0x3F);
        break;

      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = str.charCodeAt(i++);
        char3 = str.charCodeAt(i++);
        out += String.fromCharCode((c & 0x0F) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        break;
    }
  }

  return out;
}

function long2str(v, w) {
  //解密过程中将一个32位 数据转换成4个8位 的数据
  var vl = v.length;
  var n = vl - 1 << 2;

  if (w) {
    var m = v[vl - 1];
    if (m < n - 3 || m > n) return null;
    n = m;
  }

  for (var i = 0; i < vl; i++) {
    v[i] = String.fromCharCode(v[i] & 0xff, v[i] >> 8 & 0xff, v[i] >> 16 & 0xff, v[i] >> 24 & 0xff);
  }

  if (w) {
    return v.join('').substring(0, n);
  } else {
    return v.join('');
  }
}

function str2long(s, w) {
  //加密过程中将4个8位的数据转化成一个32位的数据
  var len = s.length;
  var v = [];

  for (var i = 0; i < len; i += 4) {
    v[i >> 2] = s.charCodeAt(i) | s.charCodeAt(i + 1) << 8 | s.charCodeAt(i + 2) << 16 | s.charCodeAt(i + 3) << 24;
  }

  if (w) {
    v[v.length] = len;
  }

  return v;
}

function str2longTemp(s, w) {
  //加密过程中将4个8位的数据转化成一个32位的数据
  var len = s.length;
  var v = [];

  for (var i = 0; i < len; i += 4) {
    v[i >> 2] = s.charCodeAt(i) | s.charCodeAt(i + 1) << 8 | s.charCodeAt(i + 2) << 16 | s.charCodeAt(i + 3) << 24;
  }

  if (w) {
    v[v.length] = len;
  }

  return v;
}

function encode_base64(input) {
  //base64 编码 
  var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var output = "";
  var chr1,
      chr2,
      chr3 = "";
  var enc1,
      enc2,
      enc3,
      enc4 = "";
  var i = 0;

  do {
    chr1 = input.charCodeAt(i++);
    chr2 = input.charCodeAt(i++);
    chr3 = input.charCodeAt(i++);
    enc1 = chr1 >> 2;
    enc2 = (chr1 & 3) << 4 | chr2 >> 4;
    enc3 = (chr2 & 15) << 2 | chr3 >> 6;
    enc4 = chr3 & 63;

    if (isNaN(chr2)) {
      enc3 = enc4 = 64;
    } else if (isNaN(chr3)) {
      enc4 = 64;
    }

    output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
    chr1 = chr2 = chr3 = "";
    enc1 = enc2 = enc3 = enc4 = "";
  } while (i < input.length);

  return output;
}

function decode_base64(input) {
  //base64解码 
  var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var output = "";
  var chr1,
      chr2,
      chr3 = "";
  var enc1,
      enc2,
      enc3,
      enc4 = "";
  var i = 0; // remove all characters that are not A-Z, a-z, 0-9, +, /, or = 

  var base64test = /[^A-Za-z0-9\+\/\=\n]/g;

  if (base64test.exec(input)) {
    alert("There were invalid base64 characters in the input text.\n" + "Valid base64 characters are A-Z, a-z, 0-9, '+', '/',and '='\n" + "Expect errors in decoding.");
  }

  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

  do {
    enc1 = keyStr.indexOf(input.charAt(i++));
    enc2 = keyStr.indexOf(input.charAt(i++));
    enc3 = keyStr.indexOf(input.charAt(i++));
    enc4 = keyStr.indexOf(input.charAt(i++));
    chr1 = enc1 << 2 | enc2 >> 4;
    chr2 = (enc2 & 15) << 4 | enc3 >> 2;
    chr3 = (enc3 & 3) << 6 | enc4;
    output = output + String.fromCharCode(chr1);

    if (enc3 != 64) {
      output = output + String.fromCharCode(chr2);
    }

    if (enc4 != 64) {
      output = output + String.fromCharCode(chr3);
    }

    chr1 = chr2 = chr3 = "";
    enc1 = enc2 = enc3 = enc4 = "";
  } while (i < input.length);

  return output;
} // http://www.onicos.com/staff/iz/amuse/javascript/expert/utf.txt

/* utf.js - UTF-8 <=> UTF-16 convertion
 *
 * Copyright (C) 1999 Masanao Izumo <iz@onicos.co.jp>
 * Version: 1.0
 * LastModified: Dec 25 1999
 * This library is free.  You can redistribute it and/or modify it.
 */


function Utf8ArrayToStr(array) {
  var out, i, len, c;
  var char2, char3;
  out = "";
  len = array.length;
  i = 0;

  while (i < len) {
    c = array[i++];

    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;

      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode((c & 0x1F) << 6 | char2 & 0x3F);
        break;

      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode((c & 0x0F) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        break;
    }
  }

  return out;
}

module.exports = {
  m_all_vo_: null,
  m_one_vo_: null,
  setKeyString: function setKeyString(key) {
    keyString = key;
  },
  xxtea_decrypt_to_client_db: function xxtea_decrypt_to_client_db(excelname, str, callback) {
    var data = xxtea_decrypt_base64(str);

    var result = this.__formatFile(excelname, data);

    if (callback) {
      callback(result, excelname);
    }

    return data;
  },

  /**
   * 获取当前游戏的所有文件数据 
   * [getFromFile description]
   * @param  {[type]} name [description]
   * @return  {[type]} data      [description]
   */
  getAll: function getAll() {
    var currentvo = null;
    currentvo = this.m_all_vo_ || this.m_one_vo_;

    if (currentvo == null) {
      //xxx是assets/resources目录下的一个目录名
      var files = [];

      cc.loader._resources.getUuidArray('EXCEL', null, files);

      if (files.indexOf('EXCEL/EXCEL_TO_DB_VO') > -1) {
        currentvo = eval(" require('EXCEL_TO_DB_VO') ");
      }
    }

    return currentvo;
  },

  /**
    * 通过文件名 获取 文件的json数据 
    * [getFromFile description]
    * @param  {[type]} name [description]
    * @return  {[type]} data      [description]
    */
  getFromFile: function getFromFile(name) {
    var data = null;
    var currentvo = this.getAll();

    if (cc.js.isString(name) == true) {
      if (currentvo) data = currentvo[name];
    } else {
      data = currentvo;
    }

    return data;
  },

  /**
   * 加载游戏中所有的excel数据
   * [loadFromFile description]
   * @param  {[type]} name [description]
   * @param  {[type]} callback [description]
   * @return  {[type]} data      [description]
   */
  loadAll: function loadAll(callback) {
    var data = this.getAll();

    if (data == null) {
      this.__loadAll(callback);
    } else {
      var files = []; //xxx是assets/resources目录下的一个目录名

      cc.loader._resources.getUuidArray('EXCEL', null, files); //files会得到所有的文件名


      var dataLen = Object.getOwnPropertyNames(data).length; //console.log("dataLen =>> " + dataLen);

      if (files.length > dataLen) {
        this.__loadAll(callback);
      } else {
        callback(data);
      }
    }
  },
  __loadAll: function __loadAll(callback) {
    var self = this; // 加载 test assets 目录下所有资源

    var newpath = "resources/EXCEL/"; // if (window.cc) {
    //     newpath = cc.sys.isNative ? cc.url.raw(newpath) : `res/raw-assets/${newpath}`;
    // }
    // console.log("EXCEL rrr => " ,cc.url.raw("resources/EXCEL/ba1.db"));
    // var tt = jsb.fileUtils.getStringFromFile(cc.url.raw("resources/EXCEL/ba1.db"))
    // console.log("EXCEL 123 => " ,tt);

    cc.loader.loadResDir("EXCEL", null, function (err, assets, urls) {
      for (var i = 0; i < assets.length; i++) {// assets[i] = xxtea_decrypt(assets[i]);
        // console.log("xxtea_decrypt[i] 123 => " ,xxtea_decrypt(assets[i]));
        // console.log("EXCEL xxtea_decrypt 123 => " ,xxtea_decrypt("IYp9qNVcHdvYv/xDGXwZSA=="));
      }

      ;

      var result = self.__formatAllFile(assets, urls);

      if (callback) {
        callback(self.m_one_vo_);
      }
    });
  },

  /**
  * 通过文件名 加载json数据
  * [loadFromFile description]
  * @param  {[type]} name [description]
  * @param  {[type]} callback [description]
  * @return  {[type]} data      [description]
  */
  loadFromFile: function loadFromFile(name, callback) {
    if (cc.js.isString(name) == true) {
      this.__loadFromStringFile(name, callback);
    } else {
      this.__loadFromArrFile(name, callback);
    }

    return null;
  },
  __loadFromStringFile: function __loadFromStringFile(excelname, callback) {
    var self = this;
    var data = this.getFromFile(excelname); //有数据 

    if (data) {
      if (callback) callback(data, excelname);
      return data;
    } else {
      var newpath = "EXCEL/" + excelname;
      console.log("__loadFromFile => " + newpath);

      if (false) {
        var _filePath = "xx-remote-asset/res/raw-assets/resources/EXCEL/" + excelname + ".txt";

        var _storagePath = (jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + _filePath;

        if (jsb.fileUtils.isFileExist(_storagePath)) {
          console.log(' 热更目录 文件存在 = ', _storagePath);

          if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
            data = jsb.fileUtils.getDataFromFile(_storagePath);
          }
        } else {
          // 再检查本地文件是否存在
          _storagePath = cc.url.raw("resources/EXCEL/" + excelname + ".txt");
          var isex = jsb.fileUtils.isFileExist(_storagePath);

          if (isex) {
            console.log(' 本地目录 文件存在 = ', _storagePath);

            if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
              data = jsb.fileUtils.getDataFromFile(_storagePath);
            }
          }
        }

        if (excelname == "npc" || excelname == "skill" || excelname == "mercenary" || excelname == "building" || excelname == "errorcode" || excelname == "languageen") {
          data = jsb.fileUtils.getStringFromFile(_storagePath);
        }

        ;

        if (data) {
          if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
            data = xxtea_decrypt_bytes(data);
          } // cc.log("!>>!>!>",data.length)


          var result = self.__formatFile(excelname, data);

          if (callback) {
            callback(result, excelname);
          }
        }

        ;
      } else {
        cc.loader.loadRes(newpath, function (err, data) {
          if (err) {
            cc.log(err);
          } else {
            data = xxtea_decrypt_base64(data);

            var result = self.__formatFile(excelname, data);

            if (callback) {
              callback(result, excelname);
            }
          }
        });
      }
    }
  },
  __loadFromArrFile: function __loadFromArrFile(arr, callback) {
    var self = this;
    var newpath = [];

    for (var i = 0; i < arr.length; i++) {
      var one = arr[i];
      newpath.push("EXCEL/" + one);
    }

    console.log("__loadFromFile => " + newpath);
    cc.loader.loadResArray(newpath, null, function (err, assets) {
      if (err) {
        cc.log(err);
      } else {
        self.__formatAllFile(assets, newpath);

        if (callback) {
          callback(self.m_one_vo_);
        }
      }
    });
  },

  /**
   *  格式化 
   * 当时db文件时 
   *  因为其存储的是数组，并不是hash  这样数据量会小点 
   *   所以为了保证和 导出一个javascript文件一致 必须格式转化为hash键值对 
   * 
   * [__formatFile description]
   * @param  {[type]} excelname [description]
   * @param  {[type]} data      [description]
   * @return {[type]}           [description]
   */
  __formatFile: function __formatFile(excelname, data) {
    var self = this;
    var data = JSON.parse(data);
    if (self.m_one_vo_ == null) self.m_one_vo_ = {}; // var pk = data[0];

    var datakey = data[0];
    var datatype = data[1];
    var result = {};

    for (var j = 2; j < data.length; j++) {
      var one = data[j]; //每一行数据 

      var endone = {};
      var pk = one[0];

      for (var i = 0; i < one.length; i++) {
        var onesmall = one[i];
        var key = datakey[i];
        var type = datatype[i];
        endone[key] = EXCEL_TYPE.getValue(onesmall, type);
      }

      result[pk] = endone;
    }

    self.m_one_vo_[excelname] = result;
    return result;
  },
  __formatAllFile: function __formatAllFile(assets, urls) {
    var self = this;

    for (var i = 0; i < assets.length; i++) {
      var one = assets[i];
      var oneurl = urls[i]; //EXCEL/BankConfig

      console.log("oneurl= >" + oneurl);
      console.log("one= >" + one);
      var excelname = oneurl.substring(6);

      var result = self.__formatFile(excelname, one); //self.__formatFile(excelname,one);

    }

    return self.m_one_vo_;
  }
};

cc._RF.pop();