
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./excel-to-db-plugin/EXCEL_TO_DB');
require('./excel-to-db-plugin/EXCEL_TYPE');
require('./assets/script/Rainbow');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/excel-to-db-plugin/EXCEL_TYPE.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '141679xdu5LrrHebG8bo1j6', 'EXCEL_TYPE');
// EXCEL_TYPE.js

"use strict";

/**
 *   常量类型 

 * [self description]
 * @type {[type]}
 *  
 * nickName  : "antwand",
 * site : "http://antwand.com"
 * 
 */
var self = module.exports = {
  //类型定义常量 
  type_data: {
    int32: "int32",
    int64: "int64",
    string: "string"
  },
  //导出的类型常量 
  type_formatdata_to: {
    formatdata_to_javascript_all: 0,
    //吧所有excel导出到一个js文件里
    formatdata_to_db_one: 1 //吧所有excel导出到对应单个的db文件里

  },
  //导出的选项 
  type_json_init: {
    key_row_num: 6,
    //第6行是key
    type_formatdata_to_: 0,
    //导出的格式
    EXCEL_SOURCE_Path: null,
    //excel的路径
    JSON_SOURCE_Path: null //导出json的路径 

  },

  /**
   *  吧 excel 中 值转化为对应类型的值 
   * [getValue description]
   * @type {Object}
   */
  getValue: function getValue(source, type) {
    if (type == this.type_data.int32) {
      return Number(source);
    } else if (type == this.type_data.int64) {
      return Number(source);
    } else {
      return source.toString();
    }
  }
};

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy5Db2Nvc0NyZWF0b3IvcGFja2FnZXMvZXhjZWwtdG8tZGIvcnVudGltZS1zY3JpcHRzL0VYQ0VMX1RZUEUuanMiXSwibmFtZXMiOlsic2VsZiIsIm1vZHVsZSIsImV4cG9ydHMiLCJ0eXBlX2RhdGEiLCJpbnQzMiIsImludDY0Iiwic3RyaW5nIiwidHlwZV9mb3JtYXRkYXRhX3RvIiwiZm9ybWF0ZGF0YV90b19qYXZhc2NyaXB0X2FsbCIsImZvcm1hdGRhdGFfdG9fZGJfb25lIiwidHlwZV9qc29uX2luaXQiLCJrZXlfcm93X251bSIsInR5cGVfZm9ybWF0ZGF0YV90b18iLCJFWENFTF9TT1VSQ0VfUGF0aCIsIkpTT05fU09VUkNFX1BhdGgiLCJnZXRWYWx1ZSIsInNvdXJjZSIsInR5cGUiLCJOdW1iZXIiLCJ0b1N0cmluZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBLElBQUlBLElBQUksR0FBR0MsTUFBTSxDQUFDQyxPQUFQLEdBQWlCO0VBSXhCO0VBQ0FDLFNBQVMsRUFBQztJQUNOQyxLQUFLLEVBQUMsT0FEQTtJQUVOQyxLQUFLLEVBQUMsT0FGQTtJQUdOQyxNQUFNLEVBQUM7RUFIRCxDQUxjO0VBWXZCO0VBQ0FDLGtCQUFrQixFQUFDO0lBQ2hCQyw0QkFBNEIsRUFBQyxDQURiO0lBQ2U7SUFDL0JDLG9CQUFvQixFQUFDLENBRkwsQ0FFTzs7RUFGUCxDQWJJO0VBb0J4QjtFQUNBQyxjQUFjLEVBQUM7SUFDWEMsV0FBVyxFQUFDLENBREQ7SUFDRztJQUNkQyxtQkFBbUIsRUFBQyxDQUZUO0lBRVc7SUFFdEJDLGlCQUFpQixFQUFFLElBSlI7SUFJYTtJQUN4QkMsZ0JBQWdCLEVBQUMsSUFMTixDQUtXOztFQUxYLENBckJTOztFQWdDdkI7QUFDTDtBQUNBO0FBQ0E7QUFDQTtFQUNLQyxRQXJDdUIsb0JBcUNkQyxNQXJDYyxFQXFDUEMsSUFyQ08sRUFxQ0Y7SUFDbEIsSUFBR0EsSUFBSSxJQUFJLEtBQUtkLFNBQUwsQ0FBZUMsS0FBMUIsRUFBaUM7TUFDN0IsT0FBT2MsTUFBTSxDQUFDRixNQUFELENBQWI7SUFDSCxDQUZELE1BRU0sSUFBR0MsSUFBSSxJQUFJLEtBQUtkLFNBQUwsQ0FBZUUsS0FBMUIsRUFBaUM7TUFDbkMsT0FBT2EsTUFBTSxDQUFDRixNQUFELENBQWI7SUFDSCxDQUZLLE1BRUQ7TUFDRCxPQUFPQSxNQUFNLENBQUNHLFFBQVAsRUFBUDtJQUNIO0VBQ0g7QUE3Q3NCLENBQTVCIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyJcclxuXHJcbi8qKlxyXG4gKiAgIOW4uOmHj+exu+WeiyBcclxuXHJcbiAqIFtzZWxmIGRlc2NyaXB0aW9uXVxyXG4gKiBAdHlwZSB7W3R5cGVdfVxyXG4gKiAgXHJcbiAqIG5pY2tOYW1lICA6IFwiYW50d2FuZFwiLFxyXG4gKiBzaXRlIDogXCJodHRwOi8vYW50d2FuZC5jb21cIlxyXG4gKiBcclxuICovXHJcblxyXG52YXIgc2VsZiA9IG1vZHVsZS5leHBvcnRzID0ge1xyXG4gICAgIFxyXG5cclxuXHJcbiAgICAvL+exu+Wei+WumuS5ieW4uOmHjyBcclxuICAgIHR5cGVfZGF0YTp7XHJcbiAgICAgICAgaW50MzI6XCJpbnQzMlwiLFxyXG4gICAgICAgIGludDY0OlwiaW50NjRcIixcclxuICAgICAgICBzdHJpbmc6XCJzdHJpbmdcIixcclxuICAgICB9LFxyXG5cclxuXHJcbiAgICAgLy/lr7zlh7rnmoTnsbvlnovluLjph48gXHJcbiAgICAgdHlwZV9mb3JtYXRkYXRhX3RvOntcclxuICAgICAgICBmb3JtYXRkYXRhX3RvX2phdmFzY3JpcHRfYWxsOjAsLy/lkKfmiYDmnIlleGNlbOWvvOWHuuWIsOS4gOS4qmpz5paH5Lu26YeMXHJcbiAgICAgICAgZm9ybWF0ZGF0YV90b19kYl9vbmU6MSwvL+WQp+aJgOaciWV4Y2Vs5a+85Ye65Yiw5a+55bqU5Y2V5Liq55qEZGLmlofku7bph4xcclxuICAgICB9LFxyXG4gICAgIFxyXG5cclxuXHJcbiAgICAvL+WvvOWHuueahOmAiemhuSBcclxuICAgIHR5cGVfanNvbl9pbml0OntcclxuICAgICAgICBrZXlfcm93X251bTo2LC8v56ysNuihjOaYr2tleVxyXG4gICAgICAgIHR5cGVfZm9ybWF0ZGF0YV90b186MCwvL+WvvOWHuueahOagvOW8j1xyXG5cclxuICAgICAgICBFWENFTF9TT1VSQ0VfUGF0aDogbnVsbCwvL2V4Y2Vs55qE6Lev5b6EXHJcbiAgICAgICAgSlNPTl9TT1VSQ0VfUGF0aDpudWxsLC8v5a+85Ye6anNvbueahOi3r+W+hCBcclxuICAgIH0sXHJcblxyXG5cclxuXHJcblxyXG4gICAgIC8qKlxyXG4gICAgICAqICDlkKcgZXhjZWwg5LitIOWAvOi9rOWMluS4uuWvueW6lOexu+Wei+eahOWAvCBcclxuICAgICAgKiBbZ2V0VmFsdWUgZGVzY3JpcHRpb25dXHJcbiAgICAgICogQHR5cGUge09iamVjdH1cclxuICAgICAgKi9cclxuICAgICBnZXRWYWx1ZShzb3VyY2UsdHlwZSl7XHJcbiAgICAgICAgaWYodHlwZSA9PSB0aGlzLnR5cGVfZGF0YS5pbnQzMiApe1xyXG4gICAgICAgICAgICByZXR1cm4gTnVtYmVyKHNvdXJjZSk7XHJcbiAgICAgICAgfWVsc2UgaWYodHlwZSA9PSB0aGlzLnR5cGVfZGF0YS5pbnQ2NCApe1xyXG4gICAgICAgICAgICByZXR1cm4gTnVtYmVyKHNvdXJjZSk7XHJcbiAgICAgICAgfWVsc2V7XHJcbiAgICAgICAgICAgIHJldHVybiBzb3VyY2UudG9TdHJpbmcoKTtcclxuICAgICAgICB9XHJcbiAgICAgfVxyXG59O1xyXG4iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/excel-to-db-plugin/EXCEL_TO_DB.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7a2783sZgJFXr4Nn8RLEt+q', 'EXCEL_TO_DB');
// EXCEL_TO_DB.js

"use strict";

// const Polyglot = require('polyglot.min');
var EXCEL_TYPE = require("EXCEL_TYPE"); //var path = require('path');


var keyString = "ckx*xc0125_11"; //xxtea密钥 一般16位（也可以不是16位）
// ArrayBuffer转为字符串，参数为ArrayBuffer对象

function ab2str(buf) {
  return String.fromCharCode.apply(null, new Uint32Array(buf));
} // // 字符串转为ArrayBuffer对象，参数为字符串
// function str2ab(str) {
//     var buf = new ArrayBuffer(str.length*2); // 每个字符占用2个字节
//     var bufView = new Uint8Array(buf);
//     for (var i=0, strLen=str.length; i<strLen; i++) {
//     bufView[i] = str.charCodeAt(i);
//     }
//     return buf;
// }
//----------------------------------------
//ArrayBuffer转字符串 异步
// function ab2str(u,f) {
//    var b = new Blob([u]);
//    var r = new FileReader();
//     r.readAsText(b, 'utf-8');
//     r.onload = function (){if(f)f.call(null,r.result)}
// }
// //字符串转字符串ArrayBuffer
// function str2ab(s,f) {
//     var b = new Blob([s],{type:'text/plain'});
//     var r = new FileReader();
//     r.readAsArrayBuffer(b);
//     r.onload = function (){if(f)f.call(null,r.result)}
// }
//实际调用
// ab2str(arrayBuffer,function(str){
//     //str为字符串
// });
// str2ab(str,function(ab){
//     //ab为ArrayBuffer
// });


function xxtea_encrypt(str) {
  if (str == "") {
    return "";
  }

  str = utf16ToUtf8(str); //如果是中文解析可能会出问题，加密之前先转化为utf8格式

  var v = str2long(str, true);
  var k = str2long(keyString, false);

  if (k.length < 4) {
    k.length = 4;
  }

  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = 0;

  while (0 < q--) {
    sum = sum + delta & 0xffffffff;
    e = sum >>> 2 & 3;

    for (p = 0; p < n; p++) {
      y = v[p + 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      z = v[p] = v[p] + mx & 0xffffffff;
    }

    y = v[0];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    z = v[n] = v[n] + mx & 0xffffffff;
  }

  str = long2str(v, false);
  return encode_base64(str); //加密过后用base64编码
}

function xxtea_decrypt_base64(str) {
  if (str == "") {
    return "";
  }

  str = decode_base64(str);
  var v = str2long(str, false);
  var k = str2long(keyString, false);

  if (k.length < 4) {
    k.length = 4;
  }

  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = q * delta & 0xffffffff;

  while (sum != 0) {
    e = sum >>> 2 & 3;

    for (p = n; p > 0; p--) {
      z = v[p - 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      y = v[p] = v[p] - mx & 0xffffffff;
    }

    z = v[n];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    y = v[0] = v[0] - mx & 0xffffffff;
    sum = sum - delta & 0xffffffff;
  }

  var result = long2str(v, true);
  result = utf8ToUtf16(result);
  return result;
}

function xxtea_decrypt_bytes(bytes) {
  var v = toUint32Array(bytes, false);
  var k = toUint32Array(toBytes(keyString), false);
  var n = v.length - 1;
  var z = v[n],
      y = v[0],
      delta = 0x9E3779B9;
  var mx,
      e,
      p,
      q = Math.floor(6 + 52 / (n + 1)),
      sum = q * delta & 0xffffffff;

  while (sum != 0) {
    e = sum >>> 2 & 3;

    for (p = n; p > 0; p--) {
      z = v[p - 1];
      mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
      y = v[p] = v[p] - mx & 0xffffffff;
    }

    z = v[n];
    mx = (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    y = v[0] = v[0] - mx & 0xffffffff;
    sum = sum - delta & 0xffffffff;
  }

  var test = toUint8Array(v, true);
  return toString(test);
}

function toShortString(bytes, n) {
  var charCodes = new Array(n);
  var i = 0,
      off = 0;

  for (var len = bytes.length; i < n && off < len; i++) {
    var unit = bytes[off++];

    switch (unit >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        charCodes[i] = unit;
        break;

      case 12:
      case 13:
        if (off < len) {
          charCodes[i] = (unit & 0x1F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 14:
        if (off + 1 < len) {
          charCodes[i] = (unit & 0x0F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 15:
        if (off + 2 < len) {
          var rune = ((unit & 0x07) << 18 | (bytes[off++] & 0x3F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F) - 0x10000;

          if (0 <= rune && rune <= 0xFFFFF) {
            charCodes[i++] = rune >> 10 & 0x03FF | 0xD800;
            charCodes[i] = rune & 0x03FF | 0xDC00;
          } else {
            throw new Error('Character outside valid Unicode range: 0x' + rune.toString(16));
          }
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      default:
        throw new Error('Bad UTF-8 encoding 0x' + unit.toString(16));
    }
  }

  if (i < n) {
    charCodes = charCodes.slice(0, i); //charCodes.subarray(0, i);
  }

  return String.fromCharCode.apply(String, charCodes);
}

function toLongString(bytes, n) {
  var buf = [];
  var charCodes = new Array(0xFFFF);
  var i = 0,
      off = 0;

  for (var len = bytes.length; i < n && off < len; i++) {
    var unit = bytes[off++];

    switch (unit >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        charCodes[i] = unit;
        break;

      case 12:
      case 13:
        if (off < len) {
          charCodes[i] = (unit & 0x1F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 14:
        if (off + 1 < len) {
          charCodes[i] = (unit & 0x0F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F;
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      case 15:
        if (off + 2 < len) {
          var rune = ((unit & 0x07) << 18 | (bytes[off++] & 0x3F) << 12 | (bytes[off++] & 0x3F) << 6 | bytes[off++] & 0x3F) - 0x10000;

          if (0 <= rune && rune <= 0xFFFFF) {
            charCodes[i++] = rune >> 10 & 0x03FF | 0xD800;
            charCodes[i] = rune & 0x03FF | 0xDC00;
          } else {
            throw new Error('Character outside valid Unicode range: 0x' + rune.toString(16));
          }
        } else {
          throw new Error('Unfinished UTF-8 octet sequence');
        }

        break;

      default:
        throw new Error('Bad UTF-8 encoding 0x' + unit.toString(16));
    }

    if (i >= 65534) {
      var size = i + 1;
      buf.push(String.fromCharCode.apply(String, charCodes.slice(0, size)));
      n -= size;
      i = -1;
    }
  }

  if (i > 0) {
    buf.push(String.fromCharCode.apply(String, charCodes.slice(0, i)));
  }

  return buf.join('');
}

function toString(bytes) {
  var n = bytes.length;
  if (n === 0) return '';
  return toLongString(bytes, n); //((n < 100000) ? toShortString(bytes, n) : toLongString(bytes, n));
} // byte数组转32位无符号数组


function toUint32Array(bytes, includeLength) {
  var length = bytes.length;
  var n = length >> 2;

  if ((length & 3) !== 0) {
    ++n;
  }

  var v;

  if (includeLength) {
    v = new Array(n + 1);
    v[n] = length;
  } else {
    v = new Uint32Array(n);
  }

  for (var i = 0; i < length; ++i) {
    v[i >> 2] |= bytes[i] << ((i & 3) << 3);
  }

  return v;
} // 32位无符号整数型数组 转 byte数组


function toUint8Array(v, includeLength) {
  var n;

  if (includeLength) {
    n = v[v.length - 1];
  } else {
    n = v.length << 2;
  }

  var result = new Uint8Array(n);

  for (var i = 0; i < n; i++) {
    result[i] = v[i >> 2] >> ((i & 3) << 3);
  }

  return result;
} // str转byte数组


function toBytes(str) {
  var n = str.length; // A single code unit uses at most 3 bytes.
  // Two code units at most 4.

  var bytes = new Uint8Array(n * 3);
  var length = 0;

  for (var i = 0; i < n; i++) {
    var codeUnit = str.charCodeAt(i);

    if (codeUnit < 0x80) {
      bytes[length++] = codeUnit;
    } else if (codeUnit < 0x800) {
      bytes[length++] = 0xC0 | codeUnit >> 6;
      bytes[length++] = 0x80 | codeUnit & 0x3F;
    } else if (codeUnit < 0xD800 || codeUnit > 0xDFFF) {
      bytes[length++] = 0xE0 | codeUnit >> 12;
      bytes[length++] = 0x80 | codeUnit >> 6 & 0x3F;
      bytes[length++] = 0x80 | codeUnit & 0x3F;
    } else {
      if (i + 1 < n) {
        var nextCodeUnit = str.charCodeAt(i + 1);

        if (codeUnit < 0xDC00 && 0xDC00 <= nextCodeUnit && nextCodeUnit <= 0xDFFF) {
          var rune = ((codeUnit & 0x03FF) << 10 | nextCodeUnit & 0x03FF) + 0x010000;
          bytes[length++] = 0xF0 | rune >> 18;
          bytes[length++] = 0x80 | rune >> 12 & 0x3F;
          bytes[length++] = 0x80 | rune >> 6 & 0x3F;
          bytes[length++] = 0x80 | rune & 0x3F;
          i++;
          continue;
        }
      }

      throw new Error('Malformed string');
    }
  }

  return bytes.subarray(0, length);
}

function utf16ToUtf8(str) {
  //utf16转化utf8 解决中文乱码问题 
  var out, i, len, c;
  out = "";
  len = str.length;

  for (i = 0; i < len; i++) {
    c = str.charCodeAt(i);

    if (c >= 0x0001 && c <= 0x007F) {
      out += str.charAt(i);
    } else if (c > 0x07FF) {
      out += String.fromCharCode(0xE0 | c >> 12 & 0x0F);
      out += String.fromCharCode(0x80 | c >> 6 & 0x3F);
      out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
    } else {
      out += String.fromCharCode(0xC0 | c >> 6 & 0x1F);
      out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
    }
  }

  return out;
}

function utf8ToUtf16(str) {
  var out, i, len, c;
  var char2, char3;
  out = "";
  len = str.length;
  i = 0;

  while (i < len) {
    c = str.charCodeAt(i++);

    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += str.charAt(i - 1);
        break;

      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = str.charCodeAt(i++);
        out += String.fromCharCode((c & 0x1F) << 6 | char2 & 0x3F);
        break;

      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = str.charCodeAt(i++);
        char3 = str.charCodeAt(i++);
        out += String.fromCharCode((c & 0x0F) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        break;
    }
  }

  return out;
}

function long2str(v, w) {
  //解密过程中将一个32位 数据转换成4个8位 的数据
  var vl = v.length;
  var n = vl - 1 << 2;

  if (w) {
    var m = v[vl - 1];
    if (m < n - 3 || m > n) return null;
    n = m;
  }

  for (var i = 0; i < vl; i++) {
    v[i] = String.fromCharCode(v[i] & 0xff, v[i] >> 8 & 0xff, v[i] >> 16 & 0xff, v[i] >> 24 & 0xff);
  }

  if (w) {
    return v.join('').substring(0, n);
  } else {
    return v.join('');
  }
}

function str2long(s, w) {
  //加密过程中将4个8位的数据转化成一个32位的数据
  var len = s.length;
  var v = [];

  for (var i = 0; i < len; i += 4) {
    v[i >> 2] = s.charCodeAt(i) | s.charCodeAt(i + 1) << 8 | s.charCodeAt(i + 2) << 16 | s.charCodeAt(i + 3) << 24;
  }

  if (w) {
    v[v.length] = len;
  }

  return v;
}

function str2longTemp(s, w) {
  //加密过程中将4个8位的数据转化成一个32位的数据
  var len = s.length;
  var v = [];

  for (var i = 0; i < len; i += 4) {
    v[i >> 2] = s.charCodeAt(i) | s.charCodeAt(i + 1) << 8 | s.charCodeAt(i + 2) << 16 | s.charCodeAt(i + 3) << 24;
  }

  if (w) {
    v[v.length] = len;
  }

  return v;
}

function encode_base64(input) {
  //base64 编码 
  var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var output = "";
  var chr1,
      chr2,
      chr3 = "";
  var enc1,
      enc2,
      enc3,
      enc4 = "";
  var i = 0;

  do {
    chr1 = input.charCodeAt(i++);
    chr2 = input.charCodeAt(i++);
    chr3 = input.charCodeAt(i++);
    enc1 = chr1 >> 2;
    enc2 = (chr1 & 3) << 4 | chr2 >> 4;
    enc3 = (chr2 & 15) << 2 | chr3 >> 6;
    enc4 = chr3 & 63;

    if (isNaN(chr2)) {
      enc3 = enc4 = 64;
    } else if (isNaN(chr3)) {
      enc4 = 64;
    }

    output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
    chr1 = chr2 = chr3 = "";
    enc1 = enc2 = enc3 = enc4 = "";
  } while (i < input.length);

  return output;
}

function decode_base64(input) {
  //base64解码 
  var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var output = "";
  var chr1,
      chr2,
      chr3 = "";
  var enc1,
      enc2,
      enc3,
      enc4 = "";
  var i = 0; // remove all characters that are not A-Z, a-z, 0-9, +, /, or = 

  var base64test = /[^A-Za-z0-9\+\/\=\n]/g;

  if (base64test.exec(input)) {
    alert("There were invalid base64 characters in the input text.\n" + "Valid base64 characters are A-Z, a-z, 0-9, '+', '/',and '='\n" + "Expect errors in decoding.");
  }

  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

  do {
    enc1 = keyStr.indexOf(input.charAt(i++));
    enc2 = keyStr.indexOf(input.charAt(i++));
    enc3 = keyStr.indexOf(input.charAt(i++));
    enc4 = keyStr.indexOf(input.charAt(i++));
    chr1 = enc1 << 2 | enc2 >> 4;
    chr2 = (enc2 & 15) << 4 | enc3 >> 2;
    chr3 = (enc3 & 3) << 6 | enc4;
    output = output + String.fromCharCode(chr1);

    if (enc3 != 64) {
      output = output + String.fromCharCode(chr2);
    }

    if (enc4 != 64) {
      output = output + String.fromCharCode(chr3);
    }

    chr1 = chr2 = chr3 = "";
    enc1 = enc2 = enc3 = enc4 = "";
  } while (i < input.length);

  return output;
} // http://www.onicos.com/staff/iz/amuse/javascript/expert/utf.txt

/* utf.js - UTF-8 <=> UTF-16 convertion
 *
 * Copyright (C) 1999 Masanao Izumo <iz@onicos.co.jp>
 * Version: 1.0
 * LastModified: Dec 25 1999
 * This library is free.  You can redistribute it and/or modify it.
 */


function Utf8ArrayToStr(array) {
  var out, i, len, c;
  var char2, char3;
  out = "";
  len = array.length;
  i = 0;

  while (i < len) {
    c = array[i++];

    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;

      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode((c & 0x1F) << 6 | char2 & 0x3F);
        break;

      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode((c & 0x0F) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        break;
    }
  }

  return out;
}

module.exports = {
  m_all_vo_: null,
  m_one_vo_: null,
  setKeyString: function setKeyString(key) {
    keyString = key;
  },
  xxtea_decrypt_to_client_db: function xxtea_decrypt_to_client_db(excelname, str, callback) {
    var data = xxtea_decrypt_base64(str);

    var result = this.__formatFile(excelname, data);

    if (callback) {
      callback(result, excelname);
    }

    return data;
  },

  /**
   * 获取当前游戏的所有文件数据 
   * [getFromFile description]
   * @param  {[type]} name [description]
   * @return  {[type]} data      [description]
   */
  getAll: function getAll() {
    var currentvo = null;
    currentvo = this.m_all_vo_ || this.m_one_vo_;

    if (currentvo == null) {
      //xxx是assets/resources目录下的一个目录名
      var files = [];

      cc.loader._resources.getUuidArray('EXCEL', null, files);

      if (files.indexOf('EXCEL/EXCEL_TO_DB_VO') > -1) {
        currentvo = eval(" require('EXCEL_TO_DB_VO') ");
      }
    }

    return currentvo;
  },

  /**
    * 通过文件名 获取 文件的json数据 
    * [getFromFile description]
    * @param  {[type]} name [description]
    * @return  {[type]} data      [description]
    */
  getFromFile: function getFromFile(name) {
    var data = null;
    var currentvo = this.getAll();

    if (cc.js.isString(name) == true) {
      if (currentvo) data = currentvo[name];
    } else {
      data = currentvo;
    }

    return data;
  },

  /**
   * 加载游戏中所有的excel数据
   * [loadFromFile description]
   * @param  {[type]} name [description]
   * @param  {[type]} callback [description]
   * @return  {[type]} data      [description]
   */
  loadAll: function loadAll(callback) {
    var data = this.getAll();

    if (data == null) {
      this.__loadAll(callback);
    } else {
      var files = []; //xxx是assets/resources目录下的一个目录名

      cc.loader._resources.getUuidArray('EXCEL', null, files); //files会得到所有的文件名


      var dataLen = Object.getOwnPropertyNames(data).length; //console.log("dataLen =>> " + dataLen);

      if (files.length > dataLen) {
        this.__loadAll(callback);
      } else {
        callback(data);
      }
    }
  },
  __loadAll: function __loadAll(callback) {
    var self = this; // 加载 test assets 目录下所有资源

    var newpath = "resources/EXCEL/"; // if (window.cc) {
    //     newpath = cc.sys.isNative ? cc.url.raw(newpath) : `res/raw-assets/${newpath}`;
    // }
    // console.log("EXCEL rrr => " ,cc.url.raw("resources/EXCEL/ba1.db"));
    // var tt = jsb.fileUtils.getStringFromFile(cc.url.raw("resources/EXCEL/ba1.db"))
    // console.log("EXCEL 123 => " ,tt);

    cc.loader.loadResDir("EXCEL", null, function (err, assets, urls) {
      for (var i = 0; i < assets.length; i++) {// assets[i] = xxtea_decrypt(assets[i]);
        // console.log("xxtea_decrypt[i] 123 => " ,xxtea_decrypt(assets[i]));
        // console.log("EXCEL xxtea_decrypt 123 => " ,xxtea_decrypt("IYp9qNVcHdvYv/xDGXwZSA=="));
      }

      ;

      var result = self.__formatAllFile(assets, urls);

      if (callback) {
        callback(self.m_one_vo_);
      }
    });
  },

  /**
  * 通过文件名 加载json数据
  * [loadFromFile description]
  * @param  {[type]} name [description]
  * @param  {[type]} callback [description]
  * @return  {[type]} data      [description]
  */
  loadFromFile: function loadFromFile(name, callback) {
    if (cc.js.isString(name) == true) {
      this.__loadFromStringFile(name, callback);
    } else {
      this.__loadFromArrFile(name, callback);
    }

    return null;
  },
  __loadFromStringFile: function __loadFromStringFile(excelname, callback) {
    var self = this;
    var data = this.getFromFile(excelname); //有数据 

    if (data) {
      if (callback) callback(data, excelname);
      return data;
    } else {
      var newpath = "EXCEL/" + excelname;
      console.log("__loadFromFile => " + newpath);

      if (false) {
        var _filePath = "xx-remote-asset/res/raw-assets/resources/EXCEL/" + excelname + ".txt";

        var _storagePath = (jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + _filePath;

        if (jsb.fileUtils.isFileExist(_storagePath)) {
          console.log(' 热更目录 文件存在 = ', _storagePath);

          if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
            data = jsb.fileUtils.getDataFromFile(_storagePath);
          }
        } else {
          // 再检查本地文件是否存在
          _storagePath = cc.url.raw("resources/EXCEL/" + excelname + ".txt");
          var isex = jsb.fileUtils.isFileExist(_storagePath);

          if (isex) {
            console.log(' 本地目录 文件存在 = ', _storagePath);

            if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
              data = jsb.fileUtils.getDataFromFile(_storagePath);
            }
          }
        }

        if (excelname == "npc" || excelname == "skill" || excelname == "mercenary" || excelname == "building" || excelname == "errorcode" || excelname == "languageen") {
          data = jsb.fileUtils.getStringFromFile(_storagePath);
        }

        ;

        if (data) {
          if (excelname != "npc" && excelname != "skill" && excelname != "mercenary" && excelname != "building" && excelname != "errorcode" && excelname != "languageen") {
            data = xxtea_decrypt_bytes(data);
          } // cc.log("!>>!>!>",data.length)


          var result = self.__formatFile(excelname, data);

          if (callback) {
            callback(result, excelname);
          }
        }

        ;
      } else {
        cc.loader.loadRes(newpath, function (err, data) {
          if (err) {
            cc.log(err);
          } else {
            data = xxtea_decrypt_base64(data);

            var result = self.__formatFile(excelname, data);

            if (callback) {
              callback(result, excelname);
            }
          }
        });
      }
    }
  },
  __loadFromArrFile: function __loadFromArrFile(arr, callback) {
    var self = this;
    var newpath = [];

    for (var i = 0; i < arr.length; i++) {
      var one = arr[i];
      newpath.push("EXCEL/" + one);
    }

    console.log("__loadFromFile => " + newpath);
    cc.loader.loadResArray(newpath, null, function (err, assets) {
      if (err) {
        cc.log(err);
      } else {
        self.__formatAllFile(assets, newpath);

        if (callback) {
          callback(self.m_one_vo_);
        }
      }
    });
  },

  /**
   *  格式化 
   * 当时db文件时 
   *  因为其存储的是数组，并不是hash  这样数据量会小点 
   *   所以为了保证和 导出一个javascript文件一致 必须格式转化为hash键值对 
   * 
   * [__formatFile description]
   * @param  {[type]} excelname [description]
   * @param  {[type]} data      [description]
   * @return {[type]}           [description]
   */
  __formatFile: function __formatFile(excelname, data) {
    var self = this;
    var data = JSON.parse(data);
    if (self.m_one_vo_ == null) self.m_one_vo_ = {}; // var pk = data[0];

    var datakey = data[0];
    var datatype = data[1];
    var result = {};

    for (var j = 2; j < data.length; j++) {
      var one = data[j]; //每一行数据 

      var endone = {};
      var pk = one[0];

      for (var i = 0; i < one.length; i++) {
        var onesmall = one[i];
        var key = datakey[i];
        var type = datatype[i];
        endone[key] = EXCEL_TYPE.getValue(onesmall, type);
      }

      result[pk] = endone;
    }

    self.m_one_vo_[excelname] = result;
    return result;
  },
  __formatAllFile: function __formatAllFile(assets, urls) {
    var self = this;

    for (var i = 0; i < assets.length; i++) {
      var one = assets[i];
      var oneurl = urls[i]; //EXCEL/BankConfig

      console.log("oneurl= >" + oneurl);
      console.log("one= >" + one);
      var excelname = oneurl.substring(6);

      var result = self.__formatFile(excelname, one); //self.__formatFile(excelname,one);

    }

    return self.m_one_vo_;
  }
};

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/Rainbow.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '3c56bmwY6RMbrtFrIBy6+n3', 'Rainbow');
// script/Rainbow.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rainbow = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Rainbow = /** @class */ (function (_super) {
    __extends(Rainbow, _super);
    function Rainbow() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.label = null;
        _this.text = 'hello';
        return _this;
        // update (dt) {}
    }
    // LIFE-CYCLE CALLBACKS:
    // onLoad () {}
    Rainbow.prototype.start = function () {
    };
    __decorate([
        property(cc.Label)
    ], Rainbow.prototype, "label", void 0);
    __decorate([
        property
    ], Rainbow.prototype, "text", void 0);
    Rainbow = __decorate([
        ccclass
    ], Rainbow);
    return Rainbow;
}(cc.Component));
exports.Rainbow = Rainbow;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9zY3JpcHQvUmFpbmJvdy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQ00sSUFBQSxLQUF3QixFQUFFLENBQUMsVUFBVSxFQUFuQyxPQUFPLGFBQUEsRUFBRSxRQUFRLGNBQWtCLENBQUM7QUFHNUM7SUFBNkIsMkJBQVk7SUFBekM7UUFBQSxxRUFpQkM7UUFkRyxXQUFLLEdBQWEsSUFBSSxDQUFDO1FBR3ZCLFVBQUksR0FBVyxPQUFPLENBQUM7O1FBVXZCLGlCQUFpQjtJQUNyQixDQUFDO0lBVEcsd0JBQXdCO0lBRXhCLGVBQWU7SUFFZix1QkFBSyxHQUFMO0lBRUEsQ0FBQztJQVhEO1FBREMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUM7MENBQ0k7SUFHdkI7UUFEQyxRQUFRO3lDQUNjO0lBTmQsT0FBTztRQURuQixPQUFPO09BQ0ssT0FBTyxDQWlCbkI7SUFBRCxjQUFDO0NBakJELEFBaUJDLENBakI0QixFQUFFLENBQUMsU0FBUyxHQWlCeEM7QUFqQlksMEJBQU8iLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyJcbmNvbnN0IHsgY2NjbGFzcywgcHJvcGVydHkgfSA9IGNjLl9kZWNvcmF0b3I7XG5cbkBjY2NsYXNzXG5leHBvcnQgY2xhc3MgUmFpbmJvdyBleHRlbmRzIGNjLkNvbXBvbmVudCB7XG5cbiAgICBAcHJvcGVydHkoY2MuTGFiZWwpXG4gICAgbGFiZWw6IGNjLkxhYmVsID0gbnVsbDtcblxuICAgIEBwcm9wZXJ0eVxuICAgIHRleHQ6IHN0cmluZyA9ICdoZWxsbyc7XG5cbiAgICAvLyBMSUZFLUNZQ0xFIENBTExCQUNLUzpcblxuICAgIC8vIG9uTG9hZCAoKSB7fVxuXG4gICAgc3RhcnQoKSB7XG5cbiAgICB9XG5cbiAgICAvLyB1cGRhdGUgKGR0KSB7fVxufVxuIl19
//------QC-SOURCE-SPLIT------
