#target photoshop
app.bringToFront();
#include "json2.js"
var sizeList =
    [
        { "name": "ic_launcher", "folder": "android/mipmap-hdpi", "size": 72 },
        { "name": "ic_launcher", "folder": "android/mipmap-ldpi", "size": 36 },
        { "name": "ic_launcher", "folder": "android/mipmap-mdpi", "size": 48 },
        { "name": "ic_launcher", "folder": "android/mipmap-xhdpi", "size": 96 },
        { "name": "ic_launcher", "folder": "android/mipmap-xxhdpi", "size": 144 },
        { "name": "ic_launcher", "folder": "android/mipmap-xxxhdpi", "size": 192 },
        { "name": "playstore-icon", "folder": "android", "size": 512 }
    ];

var iosConfig = {
    "images": [
        {
            "size": "20x20",
            "idiom": "iphone",
            "filename": "icon-20@2x.png",
            "scale": "2x"
        },
        {
            "size": "20x20",
            "idiom": "iphone",
            "filename": "icon-20@3x.png",
            "scale": "3x"
        },
        {
            "size": "29x29",
            "idiom": "iphone",
            "filename": "icon-29.png",
            "scale": "1x"
        },
        {
            "size": "29x29",
            "idiom": "iphone",
            "filename": "icon-29@2x.png",
            "scale": "2x"
        },
        {
            "size": "29x29",
            "idiom": "iphone",
            "filename": "icon-29@3x.png",
            "scale": "3x"
        },
        {
            "size": "40x40",
            "idiom": "iphone",
            "filename": "icon-40@2x.png",
            "scale": "2x"
        },
        {
            "size": "40x40",
            "idiom": "iphone",
            "filename": "icon-40@3x.png",
            "scale": "3x"
        },
        {
            "size": "57x57",
            "idiom": "iphone",
            "filename": "icon-57.png",
            "scale": "1x"
        },
        {
            "size": "57x57",
            "idiom": "iphone",
            "filename": "icon-57@2x.png",
            "scale": "2x"
        },
        {
            "size": "60x60",
            "idiom": "iphone",
            "filename": "icon-60@2x.png",
            "scale": "2x"
        },
        {
            "size": "60x60",
            "idiom": "iphone",
            "filename": "icon-60@3x.png",
            "scale": "3x"
        },
        {
            "size": "20x20",
            "idiom": "ipad",
            "filename": "icon-20-ipad.png",
            "scale": "1x"
        },
        {
            "size": "20x20",
            "idiom": "ipad",
            "filename": "icon-20@2x-ipad.png",
            "scale": "2x"
        },
        {
            "size": "29x29",
            "idiom": "ipad",
            "filename": "icon-29-ipad.png",
            "scale": "1x"
        },
        {
            "size": "29x29",
            "idiom": "ipad",
            "filename": "icon-29@2x-ipad.png",
            "scale": "2x"
        },
        {
            "size": "40x40",
            "idiom": "ipad",
            "filename": "icon-40.png",
            "scale": "1x"
        },
        {
            "size": "40x40",
            "idiom": "ipad",
            "filename": "icon-40@2x.png",
            "scale": "2x"
        },
        {
            "size": "50x50",
            "idiom": "ipad",
            "filename": "icon-50.png",
            "scale": "1x"
        },
        {
            "size": "50x50",
            "idiom": "ipad",
            "filename": "icon-50@2x.png",
            "scale": "2x"
        },
        {
            "size": "72x72",
            "idiom": "ipad",
            "filename": "icon-72.png",
            "scale": "1x"
        },
        {
            "size": "72x72",
            "idiom": "ipad",
            "filename": "icon-72@2x.png",
            "scale": "2x"
        },
        {
            "size": "76x76",
            "idiom": "ipad",
            "filename": "icon-76.png",
            "scale": "1x"
        },
        {
            "size": "76x76",
            "idiom": "ipad",
            "filename": "icon-76@2x.png",
            "scale": "2x"
        },
        {
            "size": "83.5x83.5",
            "idiom": "ipad",
            "filename": "icon-83.5@2x.png",
            "scale": "2x"
        },
        {
            "size": "1024x1024",
            "idiom": "ios-marketing",
            "filename": "icon-1024.png",
            "scale": "1x"
        }
    ],
    "info": {
        "version": 1,
        "author": "goudan"
    }
}

var fileRef = File.openDialog("请选择一个文件", "*.png", false);

// 选择输出目录
//var destFolder = Folder.selectDialog( "请选择一个输出的文件夹："); 

// 输出到图片所在目录
var destFolder = fileRef.parent;

//打开文件
var activeDocument = app.open(fileRef);

//运行批处理尺寸
runNow();

function runNow() {
    if (activeDocument.height != activeDocument.width) {
        alert("当前文件宽高尺寸不一致，脚本已中止。");
        return;
    }

    //以PNG格式保存，带压缩
    var pngSaveOptions = new ExportOptionsSaveForWeb();
    pngSaveOptions.format = SaveDocumentType.PNG;
    pngSaveOptions.transparency = true;
    pngSaveOptions.PNG8 = false;
    pngSaveOptions.interlaced = false;
    //pngSaveOptions.quality = 30;

    var time = new Date().getTime().toString();
    var destFileHolder = destFolder + "/icons_" + time;

    for (var i = 0; i < sizeList.length; i++) {
        //重置图像尺寸
        activeDocument.resizeImage(UnitValue(sizeList[i].size, "px"), UnitValue(sizeList[i].size, "px"), null, ResampleMethod.BICUBIC);
        var tempFolder = destFileHolder + "/" + sizeList[i].folder;
        checkFolder(tempFolder);
        var destFileName = tempFolder + "/" + sizeList[i].name + ".png";

        //保存的文件
        var saveFile = new File(destFileName);

        //如果文件已经存在就先删除它
        if (saveFile.exists) {
            saveFile.remove();
        }

        activeDocument.exportDocument(saveFile, ExportType.SAVEFORWEB, pngSaveOptions);
        activeDocument.activeHistoryState = activeDocument.historyStates[0];//还原到打开状态
    }
    var tempFolder = destFileHolder + "/ios/AppIcon.appiconset";
    for (var i = 0; i < iosConfig.images.length; ++i) {
        //重置图像尺寸
        var config = iosConfig.images[i];
        var size = parseFloat(config.size.split("x")[0]);
        var x = 1;
        var pos = config.filename.search("@");
        if (pos != -1) {
            x = parseFloat(config.filename.charAt(pos + 1));
        }

        activeDocument.resizeImage(UnitValue(size * x, "px"), UnitValue(size * x, "px"), null, ResampleMethod.BICUBIC);
        checkFolder(tempFolder);
        var destFileName = tempFolder + "/" + config.filename;

        //保存的文件
        var saveFile = new File(destFileName);

        //如果文件已经存在就先删除它
        if (saveFile.exists) {
            saveFile.remove();
        }

        activeDocument.exportDocument(saveFile, ExportType.SAVEFORWEB, pngSaveOptions);
        activeDocument.activeHistoryState = activeDocument.historyStates[0];//还原到打开状态
    }



    var filename = tempFolder + "/Contents.json";
    var jsonFile = new File(filename);
    jsonFile.open("wr")
    jsonFile.write(JSON.stringify(iosConfig));
    jsonFile.close();

    activeDocument.close(SaveOptions.DONOTSAVECHANGES);//原始被打开的文件不保存，关闭源文件
}

function checkFolder(path) {
    var folder = Folder(path);
    if (!folder.exists) folder.create();
}