import { _decorator, Component, Node, Prefab, instantiate, find, Layers, Button, EventHandler, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    @property(Prefab)
    testPrefab:Prefab = null;
    @property(Button)
    testButton: Button = null!;

    start() {

        let evts = this.testButton.clickEvents;
        for (let index = 0; index < 10; index++) {
            let item = instantiate(this.testPrefab);
            find('Canvas')?.addChild(item);
            item.setPosition(new Vec3(10+10*index,0,0))
            item.layer = Layers.Enum.UI_2D
            if(index ==1){

                let newEvt = new EventHandler();
                newEvt.target = item;
                newEvt.handler = 'clickFlash';
                newEvt.component = 'FlashSpine';
                evts.push(newEvt);
            }
        }
    }

    update(deltaTime: number) {
        
    }
}


