import { _decorator, Component, Node, RigidBody2D, PolygonCollider2D, 
    CircleCollider2D, HingeJoint2D, Vec2, PhysicsSystem2D, 
    ERigidBody2DType} from 'cc';
const { ccclass, property } = _decorator;

@ccclass('ScrewBoardDemo')
export class ScrewBoardDemo extends Component {
@property(Node)
private boardNode: Node = null!;

@property(Node)
private screwNode: Node = null!;

start() {
   // 启用物理系统
   PhysicsSystem2D.instance.enable = true;
   
   // 设置物理组件
   this.setupPhysicsComponents();
   
   // 启用物理调试（仅开发阶段）
   this.enablePhysicsDebug();
}

private setupPhysicsComponents() {
   // 设置螺丝（静态刚体）
   const screwRB = this.screwNode.addComponent(RigidBody2D);
   screwRB.type = ERigidBody2DType.Static;
   
   // 设置板子（动态刚体）
   const boardRB = this.boardNode.addComponent(RigidBody2D);
   boardRB.type = ERigidBody2DType.Dynamic;
   boardRB.angularDamping = 0; // 旋转阻尼
   
   // 设置板子碰撞器
   const boardCollider = this.boardNode.addComponent(PolygonCollider2D);
   boardCollider.points = [
       new Vec2(-180, -180),
       new Vec2(180, -180),
       new Vec2(180, 180),
       new Vec2(-180, 180)
   ];
   
   // 设置螺丝碰撞器
   const screwCollider = this.screwNode.addComponent(CircleCollider2D);
   screwCollider.radius = 5;
   
   // 设置旋转关节
   this.setupHingeJoint();
}

private setupHingeJoint() {
   const hingeJoint = this.boardNode.addComponent(HingeJoint2D);
   hingeJoint.connectedBody = this.screwNode.getComponent(RigidBody2D);
   
   // 计算螺丝在板子本地坐标系中的位置
   const boardWorldPos = this.boardNode.worldPosition;
   const screwWorldPos = this.screwNode.worldPosition;
   
   // 设置锚点（螺丝相对于板子中心的位置）
   hingeJoint.anchor = new Vec2(
       screwWorldPos.x - boardWorldPos.x,
       screwWorldPos.y - boardWorldPos.y
   );
   
   // 连接锚点（螺丝自身的中心点）
   hingeJoint.connectedAnchor = new Vec2(0, 0);
   
   // 可选：限制旋转角度（示例：-90° 到 +90°）
   hingeJoint.enableLimit = false;
   hingeJoint.lowerAngle = -Math.PI / 2;
   hingeJoint.upperAngle = Math.PI / 2;
   
   // 禁用连接刚体之间的碰撞
   hingeJoint.collideConnected = false;
}

private enablePhysicsDebug() {
//    PhysicsSystem2D.instance.debugDrawFlags = 
//        physics2d.DrawFlags.e_jointBit | 
//        physics2d.DrawFlags.e_shapeBit;
}
}