"use strict";
// import { join } from 'path';
// module.paths.push(join(Editor.App.path, 'node_modules'));
Object.defineProperty(exports, "__esModule", { value: true });
exports.onCreateMenu = exports.unload = exports.load = exports.methods = void 0;
// import { Node, Sprite } from "cc";
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
exports.methods = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    async test() {
        console.log('test method');
        Editor.Panel.open('develop');
        // ...existing code...
    },
};
/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
function load() { }
exports.load = load;
/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
function unload() { }
exports.unload = unload;
async function onCreateMenu(assetInfo) {
    console.log('节点信息:', assetInfo, Editor.Selection.getLastSelectedType(), Editor.Selection.getLastSelected("node"));
    let uuid = Editor.Selection.getLastSelected("node");
    assetInfo = await Editor.Message.request('scene', 'query-node', uuid);
    return [
        {
            label: 'i18n:创建脚本',
            async click() {
                const options = {
                    name: 'develop',
                    method: 'generateScript',
                    args: [
                        uuid,
                    ],
                };
                const result = await Editor.Message.request('scene', 'execute-scene-script', options);
            },
        },
        {
            label: 'i18n:绑定脚本属性',
            async click() {
                const options = {
                    name: 'develop',
                    method: 'bindScript',
                    args: [
                        uuid,
                    ],
                };
                const result = await Editor.Message.request('scene', 'execute-scene-script', options);
            },
        }
    ];
}
exports.onCreateMenu = onCreateMenu;
// export function onCreateMenu(assetInfo: any) {
//     return [
//         {
//             label: 'i18n:创建DLG脚本',
//             async click() {
//                 if (!assetInfo) {
//                     console.log('get create command from header menu');
//                 } else {
//                     console.log(assetInfo);
//                     const prefabBaseName: string = assetInfo.name.replace(/\.prefab$/i, '');
//                     const defaultFileName: string = prefabBaseName;
//                     // 生成默认路径（如 prefab 所在目录）
//                     // @ts-ignore
//                     const path = require('path');
//                     const defaultPath: string = path.dirname(assetInfo.file);
//                     // 弹出保存对话框
//                     // @ts-ignore
//                     const result = await Editor.Dialog.save({
//                         title: "选择你要存放的路径",
//                         path: path.join(defaultPath, defaultFileName),
//                         filters: [
//                             { name: "TypeScript Files", extensions: ["ts"] }
//                         ],
//                         button: "保存",
//                     });
//                     // 判断用户是否选择了路径
//                     if (result.filePath) {
//                         // @ts-ignore
//                         const fs = require('fs');
//                         // 这里可以自定义生成的 TypeScript 文件内容
//                         const fileContent = `// Auto generated for ${prefabBaseName}\n\nimport { _decorator } from 'cc';\nimport { BaseDialog } from '../base/BaseDialog';
// const { ccclass, property } = _decorator;\n\n@ccclass('${prefabBaseName}')\nexport class ${prefabBaseName} extends BaseDialog {
// \n    // TODO: 实现逻辑\n   onLoad() {
//         super.onLoad();
//     } \n}\n   `;
//                         fs.writeFileSync(result.filePath, fileContent, { encoding: 'utf8' });
//                         console.log('TS 文件已创建:', result.filePath);
//                     }
//                 }
//             },
//         },
//     ];
// };
// export function onAssetMenu(assetInfo: any) {
//     return [
//         {
//             label: 'i18n:assetCommandParent',
//             submenu: [
//                 {
//                     label: 'i18n:assetCommand1',
//                     enabled: assetInfo.isDirectory,
//                     click() {
//                         console.log('get it');
//                         console.log(assetInfo);
//                     },
//                 },
//                 {
//                     label: 'i18n:assetCommand2',
//                     enabled: !assetInfo.isDirectory,
//                     click() {
//                         console.log('yes, you clicked');
//                         console.log(assetInfo);
//                     },
//                 },
//             ],
//         },
//     ];
// };
//# sourceMappingURL=data:application/json;base64,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