"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toLowerFirstLetter = exports.methods = exports.unload = exports.load = void 0;
const path_1 = require("path");
module.paths.push((0, path_1.join)(Editor.App.path, 'node_modules'));
function load() { }
exports.load = load;
;
function unload() { }
exports.unload = unload;
;
exports.methods = {
    async generateScript(uuid) {
        // console.log('节点信息:', uuid, Editor.Selection.getLastSelectedType(), Editor.Selection.getLastSelected("node"));
        // 获取根节点信息
        var node = self.cce.Node.query(uuid);
        var array = new Array();
        var compenents = node.getComponentsInChildren("FindComponent");
        for (let index = 0; index < compenents.length; index++) {
            const findComponent = compenents[index];
            console.log('FindComponent:', findComponent.name);
            var type = findComponent.findComponentType;
            var expaination = findComponent.expaination;
            let name = findComponent.name.split("<")[0];
            console.log(`类型${type},注释:${expaination},{name:${name}}`);
            array.push({
                name: name,
                type: type,
                expaination: expaination,
            });
        }
        if (compenents.length > 0) {
            await processScript(node.name, array);
        }
    },
    async bindScript(uuid) {
        var node = self.cce.Node.query(uuid);
        console.log('Root node:', node, node.name, node.components);
        var compenents = node.getComponentsInChildren("FindComponent");
        if (node.getComponent(node.name)) {
            console.log('已经绑定过脚本了，跳过绑定脚本');
        }
        else {
            console.log('没有绑定过脚本');
            node.addComponent(node.name);
        }
        await Editor.Message.request('asset-db', 'refresh-asset', uuid);
        // Editor.Message.request("scene", "query-node", uuid);
        await Editor.Message.request("scene", "soft-reload");
        console.log('开始绑定属性');
        for (let index = 0; index < compenents.length; index++) {
            const findComponent = compenents[index];
            const element = {
                name: findComponent.name,
                type: findComponent.findComponentType,
            };
            let ind = 1;
            const childNode = compenents[index];
            // console.log('FindComponent:', childNode);
            if (childNode) {
                const reslutNameName = childNode.name.split("<")[0];
                const propertyType = typeTransform[element.type];
                const reslutNode = childNode.node.getComponent(`cc.${propertyType}`);
                const propertyName = toLowerFirstLetter(reslutNameName);
                const path = `__comps__.${ind}.${propertyName}`;
                let childUuid = childNode.node.uuid;
                if (propertyType != "Node") {
                    childUuid = `${reslutNode === null || reslutNode === void 0 ? void 0 : reslutNode.uuid}`;
                }
                const obj = {
                    uuid,
                    path: `${path}`,
                    dump: {
                        type: `cc.${typeTransform[element.type]}`,
                        value: {
                            uuid: `${childUuid}`,
                        }
                    }
                };
                await Editor.Message.request('scene', 'set-property', obj);
                console.log(`绑定属性 ===${reslutNameName}, 类型 = ${propertyType} 属性名称：${propertyName} 完成`);
            }
        }
        console.log('绑定属性完成');
        //保存
        await Editor.Message.request('asset-db', 'refresh-asset', uuid);
        await Editor.Message.request("scene", "save-scene");
    },
};
/**
 * 存储脚本的路径
 */
const scriptPath = "\\assets\\script\\ui\\";
/**
 * 继承的模板
 * @type {string}
 */
const extendsTemplate = ["BaseDialog", "BaseView", "Component"];
const scriptTemplate = ["../base/BaseDialog", "../base/BaseView", "cc"];
/**
 * 组件名称
 * @type {string[]}
 * */
const nameRules = ["Dlg", "View", "Component"];
/**
 * 组件类型(可扩展)，对照FindComponent组件定义的类型
 * @type {string[]}
 */
const typeTransform = ["Sprite", "Label", "Button", "Editbox", "Toggle", "Scrollview", "Progressbar", "Richtext", "Slider", "Node"];
/**
 * 生成脚本
 * @param prefabName prefab名称
 * @param array 组件信息
 */
async function processScript(prefabName, array) {
    let ruleIndex = nameRules.findIndex((item) => prefabName.endsWith(item));
    if (ruleIndex == -1) {
        ruleIndex = 2;
    }
    const prefabBaseName = prefabName;
    const defaultFileName = prefabBaseName;
    // 生成默认路径（如 prefab 所在目录）
    // @ts-ignore
    const path = require('path');
    const defaultPath = Editor.Project.path + scriptPath;
    console.log(`${defaultPath}  ${defaultFileName}`);
    // 弹出保存对话框
    // @ts-ignore
    const result = await Editor.Dialog.save({
        title: "选择你要存放的路径",
        path: path.join(defaultPath, `${defaultFileName}.ts`),
        filters: [
            { name: "TypeScript Files", extensions: ["ts"] }
        ],
        button: "保存",
    });
    var defaultDeclare = "_decorator";
    for (let i = 0; i < array.length; i++) {
        const element = array[i];
        console.log(`类型${element.type},注释:${element.expaination}`);
        if (element.type >= 0 && element.type < typeTransform.length) {
            const componentType = typeTransform[element.type]; // 获取实际的组件类型名称
            if (defaultDeclare.indexOf(componentType) == -1) {
                defaultDeclare += `,${componentType}`;
            }
        }
    }
    // 判断用户是否选择了路径
    if (result.filePath) {
        const fs = require('fs');
        // 这里可以自定义生成的 TypeScript 文件内容
        let fileContent = `// Auto generated for ${prefabBaseName}\n\nimport { ${defaultDeclare} } from 'cc';\nimport { ${extendsTemplate[ruleIndex]} } from '${scriptTemplate[ruleIndex]}';\nconst { ccclass, property } = _decorator;\n\n@ccclass('${prefabBaseName}')\nexport class ${prefabBaseName} extends ${extendsTemplate[ruleIndex]} {
\n    // TODO: 实现逻辑\n`;
        for (let i = 0; i < array.length; i++) {
            const element = array[i];
            var type = element.type;
            var name = element.name;
            var expaination = element.expaination;
            // 确保索引在有效范围内
            if (type >= 0 && type < typeTransform.length) {
                const componentType = typeTransform[type]; // 获取实际的组件类型名称
                console.log(`类型${name},注释:${toLowerFirstLetter(name)}`);
                fileContent += `    @property({\n        type:${componentType},\n        tooltip:"${expaination}"\n    })\n    //${expaination}\n    public ${toLowerFirstLetter(name)}: ${componentType};\n`;
                fileContent += "\n";
            }
            else {
                console.warn(`Invalid type index: ${type} for node: ${name}`);
            }
        }
        fileContent += `\n    onLoad() {\n        super.onLoad();\n    }\n}\n`;
        fs.writeFileSync(result.filePath, fileContent, { encoding: 'utf8' });
        console.log('TS 文件已创建:', result.filePath);
    }
}
exports.processScript = processScript;
// 添加首字母小写的辅助函数
function toLowerFirstLetter(str) {
    return str.charAt(0).toLowerCase() + str.slice(1);
}
exports.toLowerFirstLetter = toLowerFirstLetter;
exports.toLowerFirstLetter = toLowerFirstLetter;
//# sourceMappingURL=data:application/json;base64,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