"use strict";
module.exports = Editor.Panel.define({
    listeners: {
        show() { console.log('show'); },
        hide() { console.log('hide'); },
    },
    template: `
        <div>选则一个预设</div>
        <div class="node-container">
            <ui-node class="node-ui" id="node"></ui-node>
            <ui-button @confirm="onConfirm" id="btn">生成预设脚本</ui-button>
        </div>
    `,
    style: `
        div { color: white; margin-left: 5%; }
        .node-container { width: 100%; margin-left: 5%;}
        .node-ui { width: 80%; }
    `,
    $: {
        elem: 'div',
        btn: "#btn",
    },
    methods: {
        onConfirm() {
        }
    },
    ready() {
        var _a;
        (_a = this.$.btn) === null || _a === void 0 ? void 0 : _a.addEventListener('confirm', () => {
            const node = document.getElementsByClassName('node-ui');
            console.log('onConfirm', node, node.item(0));
            // @ts-ignore
            Editor.Message.send("develop", "generateScript", node.value);
        });
    },
    beforeClose() { },
    close() { },
});
//# sourceMappingURL=data:application/json;base64,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