// import { join } from 'path';
// module.paths.push(join(Editor.App.path, 'node_modules'));

// import { Node, Sprite } from "cc";
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
export const methods: { [key: string]: (...any: any) => any } = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    async test() {
        console.log('test method');
        Editor.Panel.open('develop');
        // ...existing code...
    },

};

/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
export function load() { }

/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
export function unload() { }

export async function onCreateMenu(assetInfo: any) {
    console.log('节点信息:', assetInfo, Editor.Selection.getLastSelectedType(), Editor.Selection.getLastSelected("node"));
    let uuid = Editor.Selection.getLastSelected("node");
    assetInfo = await Editor.Message.request('scene', 'query-node', uuid);
    return [
        {
            label: 'i18n:创建脚本',
            async click() {
                const options = {
                    name: 'develop',
                    method: 'generateScript',
                    args: [
                        uuid,
                    ],
                };
                const result = await Editor.Message.request('scene', 'execute-scene-script', options);

            },
        },
        {
             label: 'i18n:绑定脚本属性',
             async click() {
                const options = {
                    name: 'develop',
                    method: 'bindScript',
                    args: [
                        uuid,
                    ],
                };
                const result = await Editor.Message.request('scene', 'execute-scene-script', options);
             },
        }
    ];
}

// export function onCreateMenu(assetInfo: any) {
//     return [
//         {
//             label: 'i18n:创建DLG脚本',
//             async click() {
//                 if (!assetInfo) {
//                     console.log('get create command from header menu');
//                 } else {
//                     console.log(assetInfo);

//                     const prefabBaseName: string = assetInfo.name.replace(/\.prefab$/i, '');
//                     const defaultFileName: string = prefabBaseName;

//                     // 生成默认路径（如 prefab 所在目录）
//                     // @ts-ignore
//                     const path = require('path');
//                     const defaultPath: string = path.dirname(assetInfo.file);

//                     // 弹出保存对话框
//                     // @ts-ignore
//                     const result = await Editor.Dialog.save({
//                         title: "选择你要存放的路径",
//                         path: path.join(defaultPath, defaultFileName),
//                         filters: [
//                             { name: "TypeScript Files", extensions: ["ts"] }
//                         ],
//                         button: "保存",
//                     });

//                     // 判断用户是否选择了路径
//                     if (result.filePath) {
//                         // @ts-ignore
//                         const fs = require('fs');
//                         // 这里可以自定义生成的 TypeScript 文件内容
//                         const fileContent = `// Auto generated for ${prefabBaseName}\n\nimport { _decorator } from 'cc';\nimport { BaseDialog } from '../base/BaseDialog';
// const { ccclass, property } = _decorator;\n\n@ccclass('${prefabBaseName}')\nexport class ${prefabBaseName} extends BaseDialog {
// \n    // TODO: 实现逻辑\n   onLoad() {
//         super.onLoad();
//     } \n}\n   `;
//                         fs.writeFileSync(result.filePath, fileContent, { encoding: 'utf8' });
//                         console.log('TS 文件已创建:', result.filePath);
//                     }
//                 }
//             },
//         },
//     ];
// };

// export function onAssetMenu(assetInfo: any) {
//     return [
//         {
//             label: 'i18n:assetCommandParent',
//             submenu: [
//                 {
//                     label: 'i18n:assetCommand1',
//                     enabled: assetInfo.isDirectory,
//                     click() {
//                         console.log('get it');
//                         console.log(assetInfo);
//                     },
//                 },
//                 {
//                     label: 'i18n:assetCommand2',
//                     enabled: !assetInfo.isDirectory,
//                     click() {
//                         console.log('yes, you clicked');
//                         console.log(assetInfo);
//                     },
//                 },
//             ],
//         },
//     ];
// };