import { join } from 'path';
module.paths.push(join(Editor.App.path, 'node_modules'));

import { Button, CCObject, Component, Node, Sprite } from "cc";
export function load() { };
export function unload() { };
export const methods = {
    async generateScript(uuid: string) {
        // console.log('节点信息:', uuid, Editor.Selection.getLastSelectedType(), Editor.Selection.getLastSelected("node"));
        // 获取根节点信息
        var node: Node = (self as any).cce.Node.query(uuid);
        var array = new Array();
        var compenents: Component[] = node.getComponentsInChildren("FindComponent");
        for (let index = 0; index < compenents.length; index++) {
            const findComponent: any = compenents[index];
            console.log('FindComponent:', findComponent.name);
            var type = findComponent.findComponentType;
            var expaination = findComponent.expaination;
            let name = findComponent.name.split("<")[0];
            console.log(`类型${type},注释:${expaination},{name:${name}}`);
            array.push({
                name: name,
                type: type,
                expaination: expaination,
            });
        }
        if (compenents.length > 0) {
            await processScript(node.name, array);
        }
    },
    async bindScript(uuid: string) {
        var node: Node = (self as any).cce.Node.query(uuid);
        console.log('Root node:', node, node.name, node.components);

        var compenents: Component[] = node.getComponentsInChildren("FindComponent");
        if (node.getComponent(node.name)) {
            console.log('已经绑定过脚本了，跳过绑定脚本');
        }
        else {
            console.log('没有绑定过脚本');
            node.addComponent(node.name);
        }
        await Editor.Message.request('asset-db', 'refresh-asset', uuid);
        // Editor.Message.request("scene", "query-node", uuid);
        await Editor.Message.request("scene", "soft-reload");
        console.log('开始绑定属性');
        for (let index = 0; index < compenents.length; index++) {

            const findComponent: any = compenents[index];
            const element = {
                name: findComponent.name,
                type: findComponent.findComponentType,
            };
            let ind = 1;
            const childNode = compenents[index];
            // console.log('FindComponent:', childNode);
            if (childNode) {

                const reslutNameName: string = childNode.name.split("<")[0];
                const propertyType = typeTransform[element.type];
                const reslutNode = childNode.node.getComponent(`cc.${propertyType}`);
                const propertyName = toLowerFirstLetter(reslutNameName);
                const path = `__comps__.${ind}.${propertyName}`;
                let childUuid = childNode.node.uuid;
                if (propertyType != "Node") {
                    childUuid = `${reslutNode?.uuid}`;
                }
                const obj = {
                    uuid,
                    path: `${path}`,
                    dump: {
                        type: `cc.${typeTransform[element.type]}`,
                        value: {
                            uuid: `${childUuid}`,
                        }
                    }
                }
                await Editor.Message.request('scene', 'set-property', obj);
                console.log(`绑定属性 ===${reslutNameName}, 类型 = ${propertyType} 属性名称：${propertyName} 完成`);
            }
        }
        console.log('绑定属性完成');
        //保存
        await Editor.Message.request('asset-db', 'refresh-asset', uuid);
        await Editor.Message.request("scene", "save-scene");
    },
};
/**
 * 存储脚本的路径
 */
const scriptPath = "\\assets\\script\\ui\\";

/**
 * 继承的模板
 * @type {string}
 */
const extendsTemplate = ["BaseDialog", "BaseView", "Component"];
const scriptTemplate = ["../base/BaseDialog", "../base/BaseView", "cc"];

/**
 * 组件名称
 * @type {string[]}
 * */
const nameRules = ["Dlg", "View", "Component"];
/**
 * 组件类型(可扩展)，对照FindComponent组件定义的类型
 * @type {string[]}
 */
const typeTransform = ["Sprite", "Label", "Button", "Editbox", "Toggle", "Scrollview", "Progressbar", "Richtext", "Slider", "Node"];
/**
 * 生成脚本
 * @param prefabName prefab名称
 * @param array 组件信息
 */
async function processScript(prefabName: string, array: any) {
    let ruleIndex = nameRules.findIndex((item) => prefabName.endsWith(item));
    if (ruleIndex == -1) {
        ruleIndex = 2;
    }
    const prefabBaseName = prefabName;
    const defaultFileName = prefabBaseName;
    // 生成默认路径（如 prefab 所在目录）
    // @ts-ignore
    const path = require('path');
    const defaultPath = Editor.Project.path + scriptPath;
    console.log(`${defaultPath}  ${defaultFileName}`);
    // 弹出保存对话框
    // @ts-ignore
    const result = await Editor.Dialog.save({
        title: "选择你要存放的路径",
        path: path.join(defaultPath, `${defaultFileName}.ts`),
        filters: [
            { name: "TypeScript Files", extensions: ["ts"] }
        ],
        button: "保存",
    });
    var defaultDeclare = "_decorator";
    for (let i = 0; i < array.length; i++) {
        const element = array[i];
        console.log(`类型${element.type},注释:${element.expaination}`);
        if (element.type >= 0 && element.type < typeTransform.length) {
            const componentType = typeTransform[element.type]; // 获取实际的组件类型名称
            if (defaultDeclare.indexOf(componentType) == -1) {
                defaultDeclare += `,${componentType}`;
            }
        }
    }
    // 判断用户是否选择了路径
    if (result.filePath) {
        const fs = require('fs');
        // 这里可以自定义生成的 TypeScript 文件内容
        let fileContent = `// Auto generated for ${prefabBaseName}\n\nimport { ${defaultDeclare} } from 'cc';\nimport { ${extendsTemplate[ruleIndex]} } from '${scriptTemplate[ruleIndex]}';\nconst { ccclass, property } = _decorator;\n\n@ccclass('${prefabBaseName}')\nexport class ${prefabBaseName} extends ${extendsTemplate[ruleIndex]} {
\n    // TODO: 实现逻辑\n`;
        for (let i = 0; i < array.length; i++) {
            const element = array[i];
            var type = element.type;
            var name = element.name;
            var expaination = element.expaination;
            // 确保索引在有效范围内
            if (type >= 0 && type < typeTransform.length) {
                const componentType = typeTransform[type]; // 获取实际的组件类型名称
                console.log(`类型${name},注释:${toLowerFirstLetter(name)}`);
                fileContent += `    @property({\n        type:${componentType},\n        tooltip:"${expaination}"\n    })\n    //${expaination}\n    public ${toLowerFirstLetter(name)}: ${componentType};\n`;
                fileContent += "\n";
            }
            else {
                console.warn(`Invalid type index: ${type} for node: ${name}`);
            }
        }
        fileContent += `\n    onLoad() {\n        super.onLoad();\n    }\n}\n`;
        fs.writeFileSync(result.filePath, fileContent, { encoding: 'utf8' });
        console.log('TS 文件已创建:', result.filePath);


    }
}
exports.processScript = processScript;
// 添加首字母小写的辅助函数
export function toLowerFirstLetter(str: string): string {
    return str.charAt(0).toLowerCase() + str.slice(1);
}
exports.toLowerFirstLetter = toLowerFirstLetter;
