import { _decorator, Component, Label, Material, resources, UITransform, v2 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('labelOutlineSetting')
export class labelOutlineSetting extends Component {
    protected onLoad(): void {
        let label = this.node.getComponent(Label);
        let size = label.getComponent(UITransform).contentSize;
        resources.load("TransLabelOutline", Material, (err, mat) => {
            label.customMaterial = new Material;
            label.customMaterial.copy(mat);
            label.customMaterial.setProperty("labelSize", v2(size.width, size.height));
        })
    }
}