import AudioM from "./AudioM";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    start() {
        // init logic
        cc.audioEngine.setMusicVolume(1);
        this.label.string = this.text;
        if (AudioM.getIns().canPlayMusic) {
            AudioM.getIns().playMusic('bg_1');
        }
        this.playAudio();
    }


    playAudio() {
        for (let i = 0; i < 5; i++) {
            let ran = Math.floor(Math.random() * 5);
            let str = '';
            if (ran != 0) str = String(ran);
            AudioM.getIns().playClick(str);
            AudioM.getIns().playClose(str);
        }
    }

    inGame() {
        cc.director.loadScene('game');
    }

    restart() {
        cc.game.restart();
    }

    c_music() {
        AudioM.getIns().canPlayMusic = !AudioM.getIns().canPlayMusic;
        if (AudioM.getIns().canPlayMusic) {
            cc.audioEngine.resumeMusic();
        } else {
            cc.audioEngine.pauseMusic();
        }
    }
}
