"use strict";
cc._RF.push(module, 'f03d3VoHeBPh76Gt4BDGQu2', 'AudioM');
// Script/AudioM.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var AudioM = /** @class */ (function () {
    function AudioM() {
        this.canPlayMusic = true;
    }
    ;
    AudioM.getIns = function () {
        if (!this._instance) {
            this._instance = new AudioM();
        }
        return this._instance;
    };
    AudioM.prototype.playClose = function (str) {
        var _this = this;
        if (str === void 0) { str = ''; }
        this.loadAudioRes('common_close' + str).then(function (clip) {
            if (!_this.playingEffect)
                _this.playingEffect = {};
            _this.playingEffect[clip.name] = { time: new Date().getTime() };
            var audioID = cc.audioEngine.playEffect(clip, false);
            var self = _this;
            cc.audioEngine.setFinishCallback(audioID, function (data) {
                if (self.playingEffect[clip.name])
                    delete self.playingEffect[clip.name];
                cc.audioEngine.setFinishCallback(audioID, null);
            });
        });
    };
    AudioM.prototype.playClick = function (str) {
        var _this = this;
        if (str === void 0) { str = ''; }
        this.loadAudioRes('common_click' + str).then(function (clip) {
            if (!_this.playingEffect)
                _this.playingEffect = {};
            _this.playingEffect[clip.name] = { time: new Date().getTime() };
            var audioID = cc.audioEngine.playEffect(clip, false);
            var self = _this;
            cc.audioEngine.setFinishCallback(audioID, function (data) {
                if (self.playingEffect[clip.name])
                    delete self.playingEffect[clip.name];
                cc.audioEngine.setFinishCallback(audioID, null);
            });
        });
    };
    AudioM.prototype.playMusic = function (name) {
        this.loadAudioRes(name).then(function (clip) {
            cc.audioEngine.playMusic(clip, true);
        });
    };
    AudioM.prototype.loadAudioRes = function (audioUrl) {
        return new Promise(function (resolve, reject) {
            cc.resources.load(audioUrl, cc.AudioClip, function (err, data) {
                if (err && !data)
                    return cc.warn('loading loadRes error-> ' + audioUrl);
                resolve(data);
            });
        });
    };
    return AudioM;
}());
exports.default = AudioM;

cc._RF.pop();