const style = require('./render/style')
const Layout = require('./engine').default
const dataDemo = require('./render/dataDemo');

let __env = GameGlobal.wx || GameGlobal.tt || GameGlobal.swan;
let sharedCanvas = __env.getSharedCanvas();
let sharedContext = sharedCanvas.getContext('2d');

function draw() {
    console.log('draw');
    const template = require('./render/template')
    Layout.clear();
    Layout.init(template(dataDemo), style);
    Layout.layout(sharedContext);
}

function updateViewPort(data) {
    Layout.updateViewPort({
        x: data.x,
        y: data.y,
        width: data.width,
        height: data.height,
    });
}

__env.onMessage(data => {
    if (data.type === 'engine' && data.event === 'viewport') {
        console.log('datademo', dataDemo.data);
        updateViewPort(data);
        console.log('data', data);
        dataDemo.getFriendData(draw);
    }
});
