import { _decorator, Component, Node, profiler, BoxCollider2D, Contact2DType, EPhysics2DDrawFlags, PhysicsSystem2D, Prefab, instantiate } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('HelloWorld')
export class HelloWorld extends Component {

    @property({type:Node})
    bg:Node = null;

    @property({type:Node})
    sprite:Node = null;

    @property({type:Node})
    spriteRun:Node = null;

    @property({type:Prefab})
    res:Prefab = null;

    start() {
        profiler.showStats();

        this.schedule((dt:number)=>{
            this.spriteRun.setPosition(this.spriteRun.position.x,this.spriteRun.position.y+100*dt)
        },0.1)

        // tween(this.foodContainer)
        // .by(10,{position:v3(1800,0)})
        // .start();

        PhysicsSystem2D.instance.debugDrawFlags =
            EPhysics2DDrawFlags.Aabb | 
            EPhysics2DDrawFlags.Pair 
            |EPhysics2DDrawFlags.CenterOfMass |
            EPhysics2DDrawFlags.Joint 
            |EPhysics2DDrawFlags.Shape;
    }

    onEnable(){
        console.log("注册事件")
        this.spriteRun.getComponent(BoxCollider2D).on(Contact2DType.BEGIN_CONTACT,this.onBeginContact,this)
    }

    onBeginContact(selfCollider: BoxCollider2D, otherCollider: BoxCollider2D) {
        console.log("碰撞了");
        
        //issus 1 test:
        //this.sprite.destroy();
        //or
        //this.sprite.active = false;
        //will not work

        // issus 2 test:
        let node = instantiate(this.res)
        node.parent = this.node;
        node.setPosition(0,350);
    }

    // protected update(dt: number): void {
    //     this.foodContainer.setPosition(this.foodContainer.position.x+100*dt,this.foodContainer.position.y);
    // }
}


