import { _decorator, Component, Node, profiler, BoxCollider2D, Contact2DType, EPhysics2DDrawFlags, PhysicsSystem2D, Vec3, macro } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Magnet')
export class Magnet extends Component {

    @property({type:Node})
    food:Node = null;

    @property({type:Node})
    animal:Node = null;

    start() {
        profiler.showStats();

        this.schedule((dt:number)=>{
            this.animal.setPosition(this.animal.position.x,this.animal.position.y+130*dt)
        },0.1)

        // tween(this.foodContainer)
        // .by(10,{position:v3(1800,0)})
        // .start();

        // PhysicsSystem2D.instance.debugDrawFlags =
        //     EPhysics2DDrawFlags.Aabb | 
        //     EPhysics2DDrawFlags.Pair 
        //     |EPhysics2DDrawFlags.CenterOfMass |
        //     EPhysics2DDrawFlags.Joint 
        //     |EPhysics2DDrawFlags.Shape;
    }

    onEnable(){
        console.log("注册事件")
        // this.animal.getComponent(BoxCollider2D).on(Contact2DType.BEGIN_CONTACT,this.onBeginContact,this)
    }

    onBeginContact(selfCollider: BoxCollider2D, otherCollider: BoxCollider2D) {
        console.log("碰撞了");
         //延迟一帧隐藏没问题
        this.scheduleOnce(() => {
            this.food.active = false;
        }, 0)

        // this.scheduleOnce(() => {
        //     this.food.setPosition(this.food.position.x,this.food.position.y+200)
        //     this.food.active = true;
        // }, 0.5)

        //延迟一帧销毁没问题
        // this.scheduleOnce(() => {
        //     this.sprite.destroy();
        // }, 0)
        // Tween.stopAllByTarget(this.foodContainer)
        // this.sprite.destroy();
        // this.scheduleOnce(()=>{this.sprite.active = true},2)
    }

    protected update(dt: number): void {
        let disantce = Vec3.distance(this.animal.position,this.food.position);
        if(disantce < 5000){
            let direction = new Vec3();
            Vec3.subtract(direction,this.animal.position,this.food.position);
            direction.normalize();
            let newPosition = new Vec3();
            Vec3.add(newPosition,this.food.position,direction.multiplyScalar(150 * dt));
            // 更新物品的位置
            this.food.setPosition(newPosition);

        }
    }
}


