// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    tukuais: cc.Node[] = [];

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.node.on(cc.Node.EventType.TOUCH_START, (event) => {
            // 如果想要土块间隔处事件归属某菱形,就要土块尺寸比菱形图案大
            let node = this.tukuais.filter(v => {
                let p = v.convertToNodeSpaceAR(event.getLocation());
                console.log(v.name, p.toString(), v.height, v.width, (v.height / v.width).toFixed(2));
                return inLingXing(v.height / v.width, v.height / 2, p);
            }).pop();
            if (node) {
                console.log('in', node.name);
                let sprite = node.getComponentInChildren(cc.Sprite)
                sprite.node.color = cc.Color.RED;
                this.scheduleOnce(() => {
                    sprite.node.color = cc.Color.WHITE;
                }, 0.5);
            } else {
                console.log('in nothing');
            }
        })
    }

    start() {

    }

    // update (dt) {}
}


/*
        ^
        |
        * b, 菱形与 y 轴交点
       /|\
      / | \
     /  |  \ k, 菱形边的斜率
    /   |   \
---*---------*------>
    \   |   /
     \  |  /
      \ | /
       \|/
        *
        |
*/

// 将坐标全都转到第一象限
// 不管 pos 在第几象限,对 (x,y) 取绝对值就对称到第一象限了
// 带入公式 y = k * x + b;
// 第一象限菱形的 k 值为负,b 值为正
function inLingXing(k: number, b: number, pos: cc.Vec2) {
    // 函数内部处理了 k 和 b 的值,无论传菱形的哪条边的参数 k 和 b 都是使用的第一象限的边
    // 传入的值只要小于公式的值(公式的值在菱形的边上),就是在菱形内
    return Math.abs(pos.y) < -Math.abs(k) * Math.abs(pos.x) + Math.abs(b);
}