const { ccclass, property } = cc._decorator;
cc.macro.ENABLE_TRANSPARENT_CANVAS = true;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Button)
    public btn: cc.Button = null;

    @property(cc.VideoPlayer)
    public video: cc.VideoPlayer = null;


    protected onLoad(): void {

    }

    protected onEnable(): void {
        this.video.node.on('completed', this._onVideoCompleted, this);
    }

    protected onDisable(): void {
        this.video.node.on('completed', this._onVideoCompleted, this);
    }

    start() {
        // init logic
        this.label.string = this.text;

        this.btn.node.on("click", () => {

            this.video.play();
        })

    }

    private _onVideoCompleted() {
        // 重置播放进度到开头
        this.video.currentTime = 0;
        // 重新播放
        this.video.play();
    }

}
